/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.json;

import com.google.common.base.Preconditions;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.immutable.json.ImmutableNumberNode;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;

public final class NumberNode
extends AbstractStructForwardingNode
implements ImmutableJsonNode {
    private final StructNodeDelegate mStructNodeDel;
    private Number mNumber;

    public NumberNode(Number number, StructNodeDelegate structDel) {
        this.mNumber = number;
        this.mStructNodeDel = (StructNodeDelegate)Preconditions.checkNotNull((Object)structDel);
    }

    public void setValue(Number number) {
        this.mNumber = number;
    }

    public Number getValue() {
        return this.mNumber;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableNumberNode.of(this));
    }

    @Override
    public Kind getKind() {
        return Kind.NUMBER_VALUE;
    }

    @Override
    public StructNodeDelegate getStructNodeDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }
}

