/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.json;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nonnegative;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.immutable.json.ImmutableObjectKeyNode;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;

public final class ObjectRecordNode
extends AbstractStructForwardingNode
implements ImmutableJsonNode {
    private final StructNodeDelegate mStructNodeDel;
    private int mNameKey;
    private final String mName;
    private long mPathNodeKey;

    public ObjectRecordNode(StructNodeDelegate structDel, int nameKey, String name, long pathNodeKey) {
        assert (structDel != null);
        this.mStructNodeDel = structDel;
        this.mNameKey = nameKey;
        this.mName = name;
        this.mPathNodeKey = pathNodeKey;
    }

    public int getNameKey() {
        return this.mNameKey;
    }

    public void setLocalNameKey(int nameKey) {
        this.mNameKey = nameKey;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableObjectKeyNode.of(this));
    }

    @Override
    public Kind getKind() {
        return Kind.OBJECT_RECORD;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.mName).add("nameKey", this.mNameKey).add("structDelegate", (Object)this.mStructNodeDel).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mNameKey, this.delegate()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectRecordNode)) {
            return false;
        }
        ObjectRecordNode other = (ObjectRecordNode)obj;
        return Objects.equal((Object)this.mName, (Object)other.mName) && this.mNameKey == other.mNameKey && Objects.equal((Object)this.delegate(), (Object)other.delegate());
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    public ObjectRecordNode setPathNodeKey(@Nonnegative long pathNodeKey) {
        this.mPathNodeKey = pathNodeKey;
        return this;
    }

    public long getPathNodeKey() {
        return this.mPathNodeKey;
    }

    public String getName() {
        return this.mName;
    }
}

