/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.json;

import com.google.common.base.Preconditions;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.immutable.json.ImmutableStringNode;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;
import org.sirix.settings.Constants;

public final class StringNode
extends AbstractStructForwardingNode
implements ValueNode,
ImmutableJsonNode {
    private final ValNodeDelegate mValDel;
    private final StructNodeDelegate mStructNodeDel;

    public StringNode(ValNodeDelegate valDel, StructNodeDelegate structDel) {
        this.mStructNodeDel = (StructNodeDelegate)Preconditions.checkNotNull((Object)structDel);
        this.mValDel = (ValNodeDelegate)Preconditions.checkNotNull((Object)valDel);
    }

    @Override
    public byte[] getRawValue() {
        return this.mValDel.getRawValue();
    }

    @Override
    public void setValue(byte[] value) {
        this.mValDel.setValue(value);
    }

    @Override
    public String getValue() {
        return new String(this.mValDel.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public Kind getKind() {
        return Kind.STRING_VALUE;
    }

    @Override
    public StructNodeDelegate getStructNodeDelegate() {
        return this.mStructNodeDel;
    }

    public ValNodeDelegate getValNodeDelegate() {
        return this.mValDel;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableStringNode.of(this));
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }
}

