/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.xdm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.immutable.xdm.ImmutableAttributeNode;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.settings.Constants;

public final class AttributeNode
extends AbstractForwardingNode
implements ValueNode,
NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate mNameDel;
    private final ValNodeDelegate mValDel;
    private final NodeDelegate mNodeDel;
    private final QNm mQNm;

    public AttributeNode(NodeDelegate nodeDel, NameNodeDelegate nameDel, ValNodeDelegate valDel, QNm qNm) {
        assert (nodeDel != null) : "nodeDel must not be null!";
        this.mNodeDel = nodeDel;
        assert (nameDel != null) : "nameDel must not be null!";
        this.mNameDel = nameDel;
        assert (valDel != null) : "valDel must not be null!";
        this.mValDel = valDel;
        assert (qNm != null) : "qNm must not be null!";
        this.mQNm = qNm;
    }

    @Override
    public Kind getKind() {
        return Kind.ATTRIBUTE;
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableAttributeNode.of(this));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nameDel", (Object)this.mNameDel).add("valDel", (Object)this.mValDel).toString();
    }

    @Override
    public int getPrefixKey() {
        return this.mNameDel.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.mNameDel.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.mNameDel.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.mNameDel.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.mNameDel.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.mNameDel.setURIKey(uriKey);
    }

    @Override
    public byte[] getRawValue() {
        return this.mValDel.getRawValue();
    }

    @Override
    public void setValue(byte[] pVal) {
        this.mValDel.setValue(pVal);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNameDel, this.mValDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof AttributeNode) {
            AttributeNode other = (AttributeNode)obj;
            return Objects.equal((Object)this.mNameDel, (Object)other.mNameDel) && Objects.equal((Object)this.mValDel, (Object)other.mValDel);
        }
        return false;
    }

    @Override
    public void setPathNodeKey(@Nonnegative long pathNodeKey) {
        this.mNameDel.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.mNameDel.getPathNodeKey();
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.mNameDel;
    }

    public ValNodeDelegate getValNodeDelegate() {
        return this.mValDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mNodeDel;
    }

    @Override
    public QNm getName() {
        return this.mQNm;
    }

    @Override
    public String getValue() {
        return new String(this.mValDel.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        return this.mNodeDel.getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.mNodeDel.getTypeKey();
    }
}

