/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.xdm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.immutable.xdm.ImmutableElement;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;
import org.sirix.settings.Fixed;
import org.sirix.utils.NamePageHash;

public final class ElementNode
extends AbstractStructForwardingNode
implements NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate mNameDel;
    private final BiMap<Long, Long> mAttributes;
    private final List<Long> mAttributeKeys;
    private final List<Long> mNamespaceKeys;
    private final StructNodeDelegate mStructNodeDel;
    private final QNm mQNm;

    public ElementNode(StructNodeDelegate structDel, NameNodeDelegate nameDel, List<Long> attributeKeys, BiMap<Long, Long> attributes, List<Long> namespaceKeys, QNm qNm) {
        assert (structDel != null);
        this.mStructNodeDel = structDel;
        assert (nameDel != null);
        this.mNameDel = nameDel;
        assert (attributeKeys != null);
        this.mAttributeKeys = attributeKeys;
        assert (attributes != null);
        this.mAttributes = attributes;
        assert (namespaceKeys != null);
        this.mNamespaceKeys = namespaceKeys;
        assert (qNm != null);
        this.mQNm = qNm;
    }

    public int getAttributeCount() {
        return this.mAttributeKeys.size();
    }

    public long getAttributeKey(@Nonnegative int index) {
        if (this.mAttributeKeys.size() <= index) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        return this.mAttributeKeys.get(index);
    }

    public Optional<Long> getAttributeKeyByName(QNm name) {
        int prefixIndex = name.getPrefix() != null && !name.getPrefix().isEmpty() ? NamePageHash.generateHashForString(name.getPrefix()) : -1;
        int localNameIndex = NamePageHash.generateHashForString(name.getLocalName());
        return Optional.ofNullable((Long)this.mAttributes.get((Object)(prefixIndex + localNameIndex)));
    }

    public Optional<Long> getAttributeNameKey(@Nonnegative long key) {
        return Optional.ofNullable((Long)this.mAttributes.inverse().get((Object)key));
    }

    public void insertAttribute(@Nonnegative long attrKey, long nameIndex) {
        this.mAttributeKeys.add(attrKey);
        this.mAttributes.put((Object)nameIndex, (Object)attrKey);
    }

    public void removeAttribute(@Nonnegative long attrKey) {
        this.mAttributeKeys.remove(attrKey);
        this.mAttributes.inverse().remove((Object)attrKey);
    }

    public int getNamespaceCount() {
        return this.mNamespaceKeys.size();
    }

    public long getNamespaceKey(@Nonnegative int namespaceKey) {
        if (this.mNamespaceKeys.size() <= namespaceKey) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        return this.mNamespaceKeys.get(namespaceKey);
    }

    public void insertNamespace(long namespaceKey) {
        this.mNamespaceKeys.add(namespaceKey);
    }

    public void removeNamespace(long namespaceKey) {
        this.mNamespaceKeys.remove(namespaceKey);
    }

    @Override
    public int getPrefixKey() {
        return this.mNameDel.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.mNameDel.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.mNameDel.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.mNameDel.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.mNameDel.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.mNameDel.setURIKey(uriKey);
    }

    @Override
    public Kind getKind() {
        return Kind.ELEMENT;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nameDelegate", (Object)this.mNameDel).add("nameSpaceKeys", this.mNamespaceKeys).add("attributeKeys", this.mAttributeKeys).add("structDelegate", (Object)this.mStructNodeDel).toString();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableElement.of(this));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate(), this.mNameDel});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementNode) {
            ElementNode other = (ElementNode)obj;
            return Objects.equal((Object)this.delegate(), (Object)other.delegate()) && Objects.equal((Object)this.mNameDel, (Object)other.mNameDel);
        }
        return false;
    }

    public List<Long> getAttributeKeys() {
        return Collections.unmodifiableList(this.mAttributeKeys);
    }

    public List<Long> getNamespaceKeys() {
        return Collections.unmodifiableList(this.mNamespaceKeys);
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Nonnull
    public NameNodeDelegate getNameNodeDelegate() {
        return new NameNodeDelegate(this.mNameDel);
    }

    @Override
    public void setPathNodeKey(@Nonnegative long pathNodeKey) {
        this.mNameDel.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.mNameDel.getPathNodeKey();
    }

    @Override
    public QNm getName() {
        return this.mQNm;
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        return this.mStructNodeDel.getNodeDelegate().getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.mStructNodeDel.getNodeDelegate().getTypeKey();
    }
}

