/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.xdm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.immutable.xdm.ImmutableNamespace;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;

public final class NamespaceNode
extends AbstractForwardingNode
implements NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate mNameDel;
    private final NodeDelegate mNodeDel;
    private final QNm mQNm;

    public NamespaceNode(NodeDelegate nodeDel, NameNodeDelegate nameDel, QNm qNm) {
        assert (nodeDel != null);
        assert (nameDel != null);
        assert (qNm != null);
        this.mNodeDel = nodeDel;
        this.mNameDel = nameDel;
        this.mQNm = qNm;
    }

    @Override
    public Kind getKind() {
        return Kind.NAMESPACE;
    }

    @Override
    public int getPrefixKey() {
        return this.mNameDel.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.mNameDel.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.mNameDel.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.mNameDel.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.mNameDel.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.mNameDel.setURIKey(uriKey);
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableNamespace.of(this));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeDel, this.mNameDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NamespaceNode) {
            NamespaceNode other = (NamespaceNode)obj;
            return Objects.equal((Object)this.mNodeDel, (Object)other.mNodeDel) && Objects.equal((Object)this.mNameDel, (Object)other.mNameDel);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeDel", (Object)this.mNodeDel).add("nameDel", (Object)this.mNameDel).toString();
    }

    @Override
    public void setPathNodeKey(@Nonnegative long pathNodeKey) {
        this.mNameDel.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.mNameDel.getPathNodeKey();
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.mNameDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mNodeDel;
    }

    @Override
    public QNm getName() {
        return this.mQNm;
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        return this.mNodeDel.getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.mNodeDel.getTypeKey();
    }
}

