/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.page.CASPage;
import org.sirix.page.IndirectPage;
import org.sirix.page.NamePage;
import org.sirix.page.OverflowPage;
import org.sirix.page.PathPage;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.SerializationType;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.page.interfaces.Page;

public enum PageKind {
    RECORDPAGE(1, UnorderedKeyValuePage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new UnorderedKeyValuePage(source, pageReadTrx);
        }

        @Override
        void serializePage(DataOutput sink, Page page, SerializationType type) throws IOException {
            sink.writeByte(1.RECORDPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page nodePage, PageReadOnlyTrx pageReadTrx) {
            assert (nodePage instanceof UnorderedKeyValuePage);
            UnorderedKeyValuePage page = (UnorderedKeyValuePage)nodePage;
            return new UnorderedKeyValuePage(page.getPageKey(), page.getPageKind(), page.getPreviousReferenceKey(), pageReadTrx);
        }
    }
    ,
    NAMEPAGE(2, NamePage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new NamePage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, SerializationType type) throws IOException {
            sink.writeByte(2.NAMEPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new NamePage();
        }
    }
    ,
    UBERPAGE(3, UberPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new UberPage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, SerializationType type) throws IOException {
            sink.writeByte(3.UBERPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new UberPage();
        }
    }
    ,
    INDIRECTPAGE(4, IndirectPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new IndirectPage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, SerializationType type) throws IOException {
            sink.writeByte(4.INDIRECTPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new IndirectPage();
        }
    }
    ,
    REVISIONROOTPAGE(5, RevisionRootPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new RevisionRootPage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, SerializationType type) throws IOException {
            sink.writeByte(5.REVISIONROOTPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new RevisionRootPage();
        }
    }
    ,
    PATHSUMMARYPAGE(6, PathSummaryPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, @Nonnull SerializationType type) throws IOException {
            return new PathSummaryPage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, @Nonnull SerializationType type) throws IOException {
            sink.writeByte(6.PATHSUMMARYPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new PathSummaryPage();
        }
    }
    ,
    TEXTVALUEPAGE(7, PathPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, @Nonnull SerializationType type) throws IOException {
            return new PathPage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, @Nonnull SerializationType type) throws IOException {
            sink.writeByte(7.TEXTVALUEPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new PathPage();
        }
    }
    ,
    CASPAGE(8, CASPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new CASPage(source, type);
        }

        @Override
        void serializePage(DataOutput sink, Page page, SerializationType type) throws IOException {
            sink.writeByte(8.CASPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new CASPage();
        }
    }
    ,
    OVERFLOWPAGE(9, OverflowPage.class){

        @Override
        @Nonnull
        Page deserializePage(DataInput source, PageReadOnlyTrx pageReadTrx, SerializationType type) throws IOException {
            return new OverflowPage(source);
        }

        @Override
        void serializePage(DataOutput sink, Page page, @Nonnull SerializationType type) throws IOException {
            sink.writeByte(9.OVERFLOWPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new OverflowPage();
        }
    }
    ,
    PATHPAGE(10, PathPage.class){

        @Override
        void serializePage(DataOutput sink, @Nonnull Page page, @Nonnull SerializationType type) throws IOException {
            sink.writeByte(10.PATHPAGE.mId);
            page.serialize(sink, type);
        }

        @Override
        Page deserializePage(DataInput source, @Nonnull PageReadOnlyTrx pageReadTrx, @Nonnull SerializationType type) throws IOException {
            return new PathPage(source, type);
        }

        @Override
        @Nonnull
        public Page getInstance(Page page, @Nonnull PageReadOnlyTrx pageReadTrx) {
            return new PathPage();
        }
    };

    private static final Map<Byte, PageKind> INSTANCEFORID;
    private static final Map<Class<? extends Page>, PageKind> INSTANCEFORCLASS;
    private final byte mId;
    private final Class<? extends Page> mClass;

    private PageKind(byte pId, Class<? extends Page> clazz) {
        this.mId = pId;
        this.mClass = clazz;
    }

    public byte getID() {
        return this.mId;
    }

    abstract void serializePage(DataOutput var1, Page var2, SerializationType var3) throws IOException;

    abstract Page deserializePage(DataInput var1, PageReadOnlyTrx var2, SerializationType var3) throws IOException;

    public static PageKind getKind(byte id) {
        PageKind page = INSTANCEFORID.get(id);
        if (page == null) {
            throw new IllegalStateException();
        }
        return page;
    }

    @Nonnull
    public static PageKind getKind(Class<? extends Page> clazz) {
        PageKind page = INSTANCEFORCLASS.get(clazz);
        if (page == null) {
            throw new IllegalStateException();
        }
        return page;
    }

    @Nonnull
    public abstract Page getInstance(Page var1, PageReadOnlyTrx var2);

    static {
        INSTANCEFORID = new HashMap<Byte, PageKind>();
        INSTANCEFORCLASS = new HashMap<Class<? extends Page>, PageKind>();
        for (PageKind page : PageKind.values()) {
            INSTANCEFORID.put(page.mId, page);
            INSTANCEFORCLASS.put(page.mClass, page);
        }
    }
}

