/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnegative;
import org.magicwerk.brownies.collections.GapList;
import org.sirix.exception.SirixIOException;
import org.sirix.page.DeserializedTuple;
import org.sirix.page.PageReference;

public enum SerializationType {
    TRANSACTION_INTENT_LOG{

        @Override
        public void serialize(DataOutput out, List<PageReference> pageReferences, BitSet bitmap) {
            assert (out != null);
            assert (pageReferences != null);
            try {
                SerializationType.serializeBitSet(out, bitmap);
                for (PageReference pageReference : pageReferences) {
                    out.writeInt(pageReference.getLogKey());
                }
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public DeserializedTuple deserialize(@Nonnegative int referenceCount, DataInput in) {
            assert (in != null);
            try {
                BitSet bitmap = SerializationType.deserializeBitSet(in, referenceCount);
                int length = bitmap.cardinality();
                GapList references = new GapList(length);
                for (int offset = 0; offset < length; ++offset) {
                    int key = in.readInt();
                    PageReference reference = new PageReference();
                    reference.setLogKey(key);
                    references.add(offset, reference);
                }
                return new DeserializedTuple((List<PageReference>)references, bitmap);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
    }
    ,
    DATA{

        @Override
        public void serialize(DataOutput out, List<PageReference> pageReferences, BitSet bitmap) {
            assert (out != null);
            assert (pageReferences != null);
            try {
                SerializationType.serializeBitSet(out, bitmap);
                for (PageReference pageReference : pageReferences) {
                    out.writeLong(pageReference.getKey());
                    if (pageReference.getHash() == null) {
                        out.writeInt(-1);
                        continue;
                    }
                    byte[] hash = pageReference.getHash();
                    out.writeInt(hash.length);
                    out.write(pageReference.getHash());
                }
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }

        @Override
        public DeserializedTuple deserialize(@Nonnegative int referenceCount, DataInput in) {
            assert (in != null);
            try {
                BitSet bitmap = SerializationType.deserializeBitSet(in, referenceCount);
                int length = bitmap.cardinality();
                GapList references = new GapList(length);
                for (int offset = 0; offset < length; ++offset) {
                    long key = in.readLong();
                    PageReference reference = new PageReference();
                    reference.setKey(key);
                    int hashLength = in.readInt();
                    if (hashLength != -1) {
                        byte[] hash = new byte[hashLength];
                        in.readFully(hash);
                        reference.setHash(hash);
                    }
                    references.add(offset, (Object)reference);
                }
                return new DeserializedTuple((List<PageReference>)references, bitmap);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
    };


    private static void serializeBitSet(DataOutput out, BitSet bitmap) throws IOException {
        int len = bitmap.length();
        out.writeShort(len);
        for (int i = 0; i < len; ++i) {
            out.writeBoolean(bitmap.get(i));
        }
    }

    private static BitSet deserializeBitSet(DataInput in, @Nonnegative int referenceCount) throws IOException {
        int len = in.readShort();
        BitSet ret = new BitSet(referenceCount);
        for (int i = 0; i < len; ++i) {
            ret.set(i, in.readBoolean());
        }
        return ret;
    }

    public abstract void serialize(DataOutput var1, List<PageReference> var2, BitSet var3);

    public abstract DeserializedTuple deserialize(@Nonnegative int var1, DataInput var2);
}

