/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import javax.annotation.Nonnegative;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.exception.SirixException;

public abstract class AbstractSerializer<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
implements Callable<Void> {
    protected final ResourceManager<R, W> mResMgr;
    protected final Deque<Long> mStack = new ArrayDeque<Long>();
    protected final int[] mRevisions;
    protected final long mNodeKey;

    public AbstractSerializer(ResourceManager<R, W> resMgr, @Nonnegative int revision, int ... revisions) {
        this.mRevisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.mResMgr = (ResourceManager)Preconditions.checkNotNull(resMgr);
        this.mNodeKey = 0L;
    }

    public AbstractSerializer(ResourceManager<R, W> resMgr, @Nonnegative long key, @Nonnegative int revision, int ... revisions) {
        this.mRevisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.mResMgr = (ResourceManager)Preconditions.checkNotNull(resMgr);
        this.mNodeKey = key;
    }

    private void initialize(@Nonnegative int revision, int ... revisions) {
        this.mRevisions[0] = revision;
        if (revisions != null) {
            for (int i = 0; i < revisions.length; ++i) {
                this.mRevisions[i + 1] = revisions[i];
            }
        }
    }

    @Override
    public Void call() throws SirixException {
        this.emitStartDocument();
        int nrOfRevisions = this.mRevisions.length;
        int length = nrOfRevisions == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : nrOfRevisions;
        for (int i = 1; i <= length; ++i) {
            try (R rtx = this.mResMgr.beginNodeReadOnlyTrx(nrOfRevisions == 1 && this.mRevisions[0] < 0 ? i : this.mRevisions[i - 1]);){
                this.emitRevisionStartNode(rtx);
                rtx.moveTo(this.mNodeKey);
                DescendantAxis descAxis = new DescendantAxis((NodeCursor)rtx, IncludeSelf.YES);
                boolean closeElements = false;
                long key = rtx.getNodeKey();
                while (descAxis.hasNext()) {
                    key = (Long)descAxis.next();
                    if (closeElements) {
                        while (!this.mStack.isEmpty() && this.mStack.peek().longValue() != ((NodeCursor)rtx).getLeftSiblingKey()) {
                            rtx.moveTo(this.mStack.pop());
                            this.emitEndNode(rtx);
                            rtx.moveTo(key);
                        }
                        if (!this.mStack.isEmpty()) {
                            rtx.moveTo(this.mStack.pop());
                            this.emitEndNode(rtx);
                        }
                        rtx.moveTo(key);
                        closeElements = false;
                    }
                    long nodeKey = rtx.getNodeKey();
                    this.emitNode(rtx);
                    rtx.moveTo(nodeKey);
                    if (!rtx.isDocumentRoot() && ((NodeCursor)rtx).hasFirstChild()) {
                        this.mStack.push(rtx.getNodeKey());
                    }
                    if (((NodeCursor)rtx).hasFirstChild() || ((NodeCursor)rtx).hasRightSibling()) continue;
                    closeElements = true;
                }
                while (!this.mStack.isEmpty() && this.mStack.peek() != -15L) {
                    rtx.moveTo(this.mStack.pop());
                    this.emitEndNode(rtx);
                }
                this.emitRevisionEndNode(rtx);
                continue;
            }
        }
        this.emitEndDocument();
        return null;
    }

    protected abstract void emitStartDocument();

    protected abstract void emitNode(R var1);

    protected abstract void emitEndNode(R var1);

    protected abstract void emitRevisionStartNode(R var1);

    protected abstract void emitRevisionEndNode(R var1);

    protected abstract void emitEndDocument();
}

