/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.json.serialize;

import com.google.common.base.Preconditions;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.Database;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.api.json.JsonResourceManager;
import org.sirix.service.AbstractSerializer;
import org.sirix.service.json.serialize.JsonSerializerProperties;
import org.sirix.service.xml.serialize.XmlSerializerProperties;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.SirixFiles;
import org.slf4j.LoggerFactory;

public final class JsonSerializer
extends AbstractSerializer<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(JsonSerializer.class));
    private final Appendable mOut;
    private final boolean mIndent;
    private final int mIndentSpaces;
    private final boolean mWithInitialIndent;
    private final boolean mEmitXQueryResultSequence;
    private final boolean mSerializeTimestamp;

    private JsonSerializer(JsonResourceManager resourceMgr, @Nonnegative long nodeKey, Builder builder, boolean initialIndent, @Nonnegative int revision, int ... revsions) {
        super(resourceMgr, nodeKey, revision, revsions);
        this.mOut = builder.mStream;
        this.mIndent = builder.mIndent;
        this.mIndentSpaces = builder.mIndentSpaces;
        this.mWithInitialIndent = builder.mInitialIndent;
        this.mEmitXQueryResultSequence = builder.mEmitXQueryResultSequence;
        this.mSerializeTimestamp = builder.mSerializeTimestamp;
    }

    @Override
    protected void emitNode(JsonNodeReadOnlyTrx rtx) {
        try {
            switch (rtx.getKind()) {
                case JSON_DOCUMENT: {
                    break;
                }
                case OBJECT: {
                    this.indent();
                    this.mOut.append("{");
                    if (!rtx.hasFirstChild()) {
                        this.mOut.append("}");
                        if (rtx.hasRightSibling()) {
                            this.mOut.append(",");
                        }
                    }
                    break;
                }
                case ARRAY: {
                    this.mOut.append("[");
                    if (!rtx.hasFirstChild()) {
                        this.mOut.append("]");
                        if (rtx.hasRightSibling()) {
                            this.mOut.append(",");
                        }
                    }
                    break;
                }
                case OBJECT_RECORD: {
                    this.mOut.append("\"" + rtx.getName().stringValue() + "\":");
                    break;
                }
                case BOOLEAN_VALUE: {
                    this.mOut.append(Boolean.valueOf(rtx.getValue()).toString());
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                case NULL_VALUE: {
                    this.mOut.append("null");
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                case NUMBER_VALUE: {
                    this.mOut.append(rtx.getValue());
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                case STRING_VALUE: {
                    this.mOut.append("\"" + rtx.getValue() + "\"");
                    this.printCommaIfNeeded(rtx);
                    break;
                }
                default: {
                    throw new IllegalStateException("Node kind not known!");
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private void printCommaIfNeeded(JsonNodeReadOnlyTrx rtx) throws IOException {
        boolean hasRightSibling = rtx.hasRightSibling();
        if (hasRightSibling) {
            this.mOut.append(",");
        }
    }

    @Override
    protected void emitEndNode(JsonNodeReadOnlyTrx rtx) {
        try {
            this.indent();
            switch (rtx.getKind()) {
                case ARRAY: {
                    this.mOut.append("]");
                    break;
                }
                case OBJECT: {
                    this.mOut.append("}");
                    if (!rtx.hasRightSibling()) break;
                    this.mOut.append(",");
                    break;
                }
                case OBJECT_RECORD: {
                    if (!rtx.hasRightSibling()) break;
                    this.mOut.append(",");
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitStartDocument() {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (length > 1) {
                this.mOut.append("{");
                if (this.mIndent) {
                    this.mStack.push(-15L);
                }
                this.mOut.append("\"sirix\":");
                this.mOut.append("[");
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndDocument() {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (length > 1) {
                if (this.mIndent) {
                    this.mStack.pop();
                }
                this.indent();
                this.mOut.append("]");
                this.indent();
                this.mOut.append("}");
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionStartNode(@Nonnull JsonNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (this.mEmitXQueryResultSequence || length > 1) {
                this.indent();
                if (length > 1 || this.mEmitXQueryResultSequence) {
                    this.mOut.append("{");
                    this.mOut.append("\"revisionNumber\":");
                    this.mOut.append(Integer.toString(rtx.getRevisionNumber()));
                    this.mOut.append(",");
                    if (this.mSerializeTimestamp) {
                        this.mOut.append("\"revisionTimestamp\":");
                        this.mOut.append("\"" + DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).format(rtx.getRevisionTimestamp()) + "\"");
                        this.mOut.append(",");
                    }
                    this.mOut.append("\"revision\":");
                }
                if (rtx.hasFirstChild()) {
                    this.mStack.push(-15L);
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionEndNode(@Nonnull JsonNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (this.mEmitXQueryResultSequence || length > 1) {
                if (rtx.moveToDocumentRoot().trx().hasFirstChild()) {
                    this.mStack.pop();
                }
                this.indent();
                this.mOut.append("}");
                if (this.hasMoreRevisionsToSerialize(rtx)) {
                    this.mOut.append(",");
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private boolean hasMoreRevisionsToSerialize(JsonNodeReadOnlyTrx rtx) {
        return rtx.getRevisionNumber() < this.mRevisions[this.mRevisions.length - 1] || this.mRevisions.length == 1 && this.mRevisions[0] == -1 && rtx.getRevisionNumber() < rtx.getResourceManager().getMostRecentRevisionNumber();
    }

    private void indent() throws IOException {
        if (this.mIndent) {
            int indentSpaces = this.mWithInitialIndent ? (this.mStack.size() + 1) * this.mIndentSpaces : this.mStack.size() * this.mIndentSpaces;
            for (int i = 0; i < indentSpaces; ++i) {
                this.mOut.append(" ");
            }
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            throw new IllegalArgumentException("Usage: XMLSerializer input-TT output.xml");
        }
        LOGWRAPPER.info("Serializing '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path target = Paths.get(args[1], new String[0]);
        SirixFiles.recursiveRemove(target);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.createFile(target, new FileAttribute[0]);
        Path databaseFile = Paths.get(args[0], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(databaseFile);
        Databases.createJsonDatabase(config);
        try (Database<JsonResourceManager> db = Databases.openJsonDatabase(databaseFile);){
            db.createResource(new ResourceConfiguration.Builder("shredded").build());
            try (JsonResourceManager resMgr = db.openResourceManager("shredded");
                 FileWriter outputStream = new FileWriter(target.toFile());){
                JsonSerializer serializer = JsonSerializer.newBuilder(resMgr, outputStream, new int[0]).build();
                serializer.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + "ms].", new Object[0]);
    }

    public static Builder newBuilder(JsonResourceManager resMgr, Writer stream, int ... revisions) {
        return new Builder(resMgr, stream, revisions);
    }

    public static Builder newBuilder(JsonResourceManager resMgr, @Nonnegative long nodeKey, Writer stream, JsonSerializerProperties properties, int ... revisions) {
        return new Builder(resMgr, nodeKey, stream, properties, revisions);
    }

    public static final class Builder {
        private boolean mIndent;
        private int mIndentSpaces = 2;
        private final Appendable mStream;
        private final JsonResourceManager mResourceMgr;
        private int[] mVersions;
        private int mVersion;
        private long mNodeKey;
        private boolean mInitialIndent;
        private boolean mEmitXQueryResultSequence;
        private boolean mSerializeTimestamp;

        public Builder(JsonResourceManager resourceMgr, Appendable stream, int ... revisions) {
            this.mNodeKey = 0L;
            this.mResourceMgr = (JsonResourceManager)Preconditions.checkNotNull((Object)resourceMgr);
            this.mStream = (Appendable)Preconditions.checkNotNull((Object)stream);
            if (revisions == null || revisions.length == 0) {
                this.mVersion = this.mResourceMgr.getMostRecentRevisionNumber();
            } else {
                this.mVersion = revisions[0];
                this.mVersions = new int[revisions.length - 1];
                for (int i = 0; i < revisions.length - 1; ++i) {
                    this.mVersions[i] = revisions[i + 1];
                }
            }
        }

        public Builder(JsonResourceManager resourceMgr, @Nonnegative long nodeKey, Writer stream, JsonSerializerProperties properties, int ... revisions) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"pNodeKey must be >= 0!");
            this.mResourceMgr = (JsonResourceManager)Preconditions.checkNotNull((Object)resourceMgr);
            this.mNodeKey = nodeKey;
            this.mStream = (Appendable)Preconditions.checkNotNull((Object)stream);
            if (revisions == null || revisions.length == 0) {
                this.mVersion = this.mResourceMgr.getMostRecentRevisionNumber();
            } else {
                this.mVersion = revisions[0];
                this.mVersions = new int[revisions.length - 1];
                for (int i = 0; i < revisions.length - 1; ++i) {
                    this.mVersions[i] = revisions[i + 1];
                }
            }
            ConcurrentMap map = (ConcurrentMap)Preconditions.checkNotNull(properties.getProps());
            this.mIndent = (Boolean)Preconditions.checkNotNull((Object)((Boolean)map.get(XmlSerializerProperties.S_INDENT[0])));
            this.mIndentSpaces = (Integer)Preconditions.checkNotNull((Object)((Integer)map.get(XmlSerializerProperties.S_INDENT_SPACES[0])));
        }

        public Builder startNodeKey(long nodeKey) {
            this.mNodeKey = nodeKey;
            return this;
        }

        public Builder withInitialIndent() {
            this.mInitialIndent = true;
            return this;
        }

        public Builder isXQueryResultSequence() {
            this.mEmitXQueryResultSequence = true;
            return this;
        }

        public Builder serializeTimestamp(boolean serializeTimestamp) {
            this.mSerializeTimestamp = serializeTimestamp;
            return this;
        }

        public Builder prettyPrint() {
            this.mIndent = true;
            return this;
        }

        public Builder revisions(int[] revisions) {
            Preconditions.checkNotNull((Object)revisions);
            this.mVersion = revisions[0];
            this.mVersions = new int[revisions.length - 1];
            for (int i = 0; i < revisions.length - 1; ++i) {
                this.mVersions[i] = revisions[i + 1];
            }
            return this;
        }

        public JsonSerializer build() {
            return new JsonSerializer(this.mResourceMgr, this.mNodeKey, this, this.mInitialIndent, this.mVersion, this.mVersions);
        }
    }
}

