/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.serialize;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import javax.annotation.Nonnegative;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.exception.SirixException;
import org.sirix.node.Kind;

public abstract class AbstractSerializer
implements Callable<Void> {
    protected final XmlResourceManager mResMgr;
    protected final Deque<Long> mStack = new ArrayDeque<Long>();
    protected final int[] mRevisions;
    protected final long mNodeKey;

    public AbstractSerializer(XmlResourceManager resMgr, @Nonnegative int revision, int ... revisions) {
        this.mRevisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.mResMgr = (XmlResourceManager)Preconditions.checkNotNull((Object)resMgr);
        this.mNodeKey = 0L;
    }

    public AbstractSerializer(XmlResourceManager resMgr, @Nonnegative long key, @Nonnegative int revision, int ... revisions) {
        this.mRevisions = revisions == null ? new int[1] : new int[revisions.length + 1];
        this.initialize(revision, revisions);
        this.mResMgr = (XmlResourceManager)Preconditions.checkNotNull((Object)resMgr);
        this.mNodeKey = key;
    }

    private void initialize(@Nonnegative int revision, int ... revisions) {
        this.mRevisions[0] = revision;
        if (revisions != null) {
            for (int i = 0; i < revisions.length; ++i) {
                this.mRevisions[i + 1] = revisions[i];
            }
        }
    }

    @Override
    public Void call() throws SirixException {
        this.emitStartDocument();
        int nrOfRevisions = this.mRevisions.length;
        int length = nrOfRevisions == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : nrOfRevisions;
        for (int i = 1; i <= length; ++i) {
            try (XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.mResMgr.beginNodeReadOnlyTrx(nrOfRevisions == 1 && this.mRevisions[0] < 0 ? i : this.mRevisions[i - 1]);){
                this.emitRevisionStartTag(rtx);
                rtx.moveTo(this.mNodeKey);
                DescendantAxis descAxis = new DescendantAxis(rtx, IncludeSelf.YES);
                boolean closeElements = false;
                long key = rtx.getNodeKey();
                while (descAxis.hasNext()) {
                    key = (Long)descAxis.next();
                    if (closeElements) {
                        while (!this.mStack.isEmpty() && this.mStack.peek().longValue() != rtx.getLeftSiblingKey()) {
                            rtx.moveTo(this.mStack.pop());
                            this.emitEndTag(rtx);
                            rtx.moveTo(key);
                        }
                        if (!this.mStack.isEmpty()) {
                            rtx.moveTo(this.mStack.pop());
                            this.emitEndTag(rtx);
                        }
                        rtx.moveTo(key);
                        closeElements = false;
                    }
                    this.emitNode(rtx);
                    if (rtx.getKind() == Kind.ELEMENT && rtx.hasFirstChild()) {
                        this.mStack.push(rtx.getNodeKey());
                    }
                    if (rtx.hasFirstChild() || rtx.hasRightSibling()) continue;
                    closeElements = true;
                }
                while (!this.mStack.isEmpty() && this.mStack.peek() != -15L) {
                    rtx.moveTo(this.mStack.pop());
                    this.emitEndTag(rtx);
                }
                this.emitRevisionEndTag(rtx);
                continue;
            }
        }
        this.emitEndDocument();
        return null;
    }

    protected abstract void emitStartDocument();

    protected abstract void emitNode(XmlNodeReadOnlyTrx var1);

    protected abstract void emitEndTag(XmlNodeReadOnlyTrx var1);

    protected abstract void emitRevisionStartTag(XmlNodeReadOnlyTrx var1);

    protected abstract void emitRevisionEndTag(XmlNodeReadOnlyTrx var1);

    protected abstract void emitEndDocument();
}

