/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.shredder;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.exception.SirixException;
import org.sirix.node.Kind;
import org.sirix.service.xml.shredder.InsertPosition;
import org.sirix.service.xml.shredder.Shredder;
import org.sirix.settings.Fixed;

public abstract class AbstractShredder
implements Shredder<String, QNm> {
    private final XmlNodeTrx mWtx;
    private final Deque<Long> mParents;
    private InsertPosition mInsertLocation;

    public AbstractShredder(XmlNodeTrx wtx, InsertPosition insertLocation) {
        this.mWtx = (XmlNodeTrx)Preconditions.checkNotNull((Object)wtx);
        this.mInsertLocation = (InsertPosition)((Object)Preconditions.checkNotNull((Object)((Object)insertLocation)));
        this.mParents = new ArrayDeque<Long>();
        this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public void processComment(String commentValue) throws SirixException {
        String value = (String)Preconditions.checkNotNull((Object)commentValue);
        if (!value.isEmpty()) {
            long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertCommentAsFirstChild(value).getNodeKey() : this.mWtx.insertCommentAsRightSibling(value).getNodeKey();
            this.mParents.pop();
            this.mParents.push(key);
        }
    }

    @Override
    public void processPI(String processingContent, String processingTarget) throws SirixException {
        String content = (String)Preconditions.checkNotNull((Object)processingContent);
        String target = (String)Preconditions.checkNotNull((Object)processingTarget);
        if (!target.isEmpty()) {
            long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertPIAsFirstChild(target, content).getNodeKey() : this.mWtx.insertPIAsRightSibling(target, content).getNodeKey();
            this.mParents.pop();
            this.mParents.push(key);
        }
    }

    @Override
    public void processText(String textValue) throws SirixException {
        String text = (String)Preconditions.checkNotNull((Object)textValue);
        if (!text.isEmpty()) {
            long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertTextAsFirstChild(text).getNodeKey() : this.mWtx.insertTextAsRightSibling(text).getNodeKey();
            this.mParents.pop();
            this.mParents.push(key);
        }
    }

    @Override
    public void processStartTag(QNm elementName) throws SirixException {
        QNm name = (QNm)Preconditions.checkNotNull((Object)elementName);
        long key = -1L;
        switch (this.mInsertLocation) {
            case AS_FIRST_CHILD: {
                if (this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.mWtx.insertElementAsFirstChild(name).getNodeKey();
                    break;
                }
                key = this.mWtx.insertElementAsRightSibling(name).getNodeKey();
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.mWtx.getKind() == Kind.XDM_DOCUMENT || this.mWtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-element!");
                }
                key = this.mWtx.insertElementAsRightSibling(name).getNodeKey();
                this.mInsertLocation = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            case AS_LEFT_SIBLING: {
                if (this.mWtx.getKind() == Kind.XDM_DOCUMENT || this.mWtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-element!");
                }
                key = this.mWtx.insertElementAsLeftSibling(name).getNodeKey();
                this.mInsertLocation = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mParents.pop();
        this.mParents.push(key);
        this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public void processEndTag(QNm elementName) {
        this.mParents.pop();
        this.mWtx.moveTo(this.mParents.peek());
    }

    @Override
    public void processEmptyElement(QNm elementName) throws SirixException {
        this.processStartTag(elementName);
        this.processEndTag(elementName);
    }
}

