/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.expr;

import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.service.xml.xpath.SingleType;
import org.sirix.service.xml.xpath.XPathError;
import org.sirix.service.xml.xpath.expr.AbstractExpression;
import org.sirix.service.xml.xpath.types.Type;

public class CastExpr
extends AbstractExpression {
    private final Axis mSourceExpr;
    private final Type mTargetType;
    private final boolean mPermitEmptySeq;

    public CastExpr(XmlNodeReadOnlyTrx rtx, Axis mInputExpr, SingleType mTarget) {
        super(rtx);
        this.mSourceExpr = mInputExpr;
        this.mTargetType = mTarget.getAtomic();
        this.mPermitEmptySeq = mTarget.hasInterogation();
    }

    @Override
    public void reset(long mNodeKey) {
        super.reset(mNodeKey);
        if (this.mSourceExpr != null) {
            this.mSourceExpr.reset(mNodeKey);
        }
    }

    @Override
    public void evaluate() throws SirixXPathException {
        if (this.mTargetType == Type.ANY_ATOMIC_TYPE || this.mTargetType == Type.NOTATION) {
            throw new XPathError(XPathError.ErrorType.XPST0080);
        }
        if (this.mSourceExpr.hasNext()) {
            this.mSourceExpr.next();
            Type sourceType = Type.getType(this.asXdmNodeReadTrx().getTypeKey());
            String sourceValue = this.asXdmNodeReadTrx().getValue();
            if (sourceType.isCastableTo(this.mTargetType, sourceValue)) {
                throw new IllegalStateException("casts not implemented yet.");
            }
            if (this.mSourceExpr.hasNext()) {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
        } else if (!this.mPermitEmptySeq) {
            throw new XPathError(XPathError.ErrorType.XPTY0004);
        }
    }
}

