/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.expr;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.service.xml.xpath.AbstractAxis;
import org.sirix.service.xml.xpath.expr.VarRefExpr;

public class VariableAxis
extends AbstractAxis {
    private final Axis mBindingSeq;
    private final List<VarRefExpr> mVarRefs;

    public VariableAxis(XmlNodeReadOnlyTrx pRtx, @Nonnull Axis pInSeq) {
        super(pRtx);
        this.mBindingSeq = (Axis)Preconditions.checkNotNull((Object)pInSeq);
        this.mVarRefs = new ArrayList<VarRefExpr>();
    }

    @Override
    public void reset(long pNodeKey) {
        super.reset(pNodeKey);
        if (this.mBindingSeq != null) {
            this.mBindingSeq.reset(pNodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.isNext()) {
            return true;
        }
        this.resetToLastKey();
        if (this.mBindingSeq.hasNext()) {
            this.mKey = (Long)this.mBindingSeq.next();
            this.notifyObs();
            return true;
        }
        this.resetToStartKey();
        return false;
    }

    private void notifyObs() {
        for (VarRefExpr varRef : this.mVarRefs) {
            varRef.update(this.asXdmNodeReadTrx().getNodeKey());
        }
    }

    public void addObserver(VarRefExpr pObserver) {
        this.mVarRefs.add((VarRefExpr)Preconditions.checkNotNull((Object)pObserver));
    }
}

