/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.functions;

import java.util.List;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.EXPathError;
import org.sirix.service.xml.xpath.expr.AbstractExpression;

public abstract class AbstractFunction
extends AbstractExpression {
    private final List<Axis> mArgs;
    private final int mMin;
    private final int mMax;
    private final int mReturnType;

    public AbstractFunction(XmlNodeReadOnlyTrx rtx, List<Axis> args, int min, int max, int returnType) throws SirixXPathException {
        super(rtx);
        this.mArgs = args;
        this.mMin = min;
        this.mMax = max;
        this.mReturnType = returnType;
        this.varifyParam(args.size());
    }

    public final void varifyParam(int mNumber) throws SirixXPathException {
        if (mNumber < this.mMin || mNumber > this.mMax) {
            throw EXPathError.XPST0017.getEncapsulatedException();
        }
    }

    @Override
    public void reset(long mNodeKey) {
        super.reset(mNodeKey);
        if (this.mArgs != null) {
            for (Axis ax : this.mArgs) {
                ax.reset(mNodeKey);
            }
        }
    }

    @Override
    public void evaluate() throws SirixXPathException {
        byte[] value = this.computeResult();
        int itemKey = this.asXdmNodeReadTrx().getItemList().addItem(new AtomicValue(value, this.mReturnType));
        this.mKey = itemKey;
    }

    protected abstract byte[] computeResult() throws SirixXPathException;

    protected List<Axis> getArgs() {
        return this.mArgs;
    }
}

