/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.operators;

import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.node.interfaces.Node;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.XPathError;
import org.sirix.service.xml.xpath.operators.AbstractObAxis;
import org.sirix.service.xml.xpath.types.Type;
import org.sirix.utils.TypedValue;

public class DivOpAxis
extends AbstractObAxis {
    public DivOpAxis(XmlNodeReadOnlyTrx rtx, Axis mOp1, Axis mOp2) {
        super(rtx, mOp1, mOp2);
    }

    @Override
    public Node operate(AtomicValue mOperand1, AtomicValue mOperand2) throws SirixXPathException {
        Type returnType = this.getReturnType(mOperand1.getTypeKey(), mOperand2.getTypeKey());
        int typeKey = this.asXdmNodeReadTrx().keyForName(returnType.getStringRepr());
        switch (returnType) {
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: {
                double aD = Double.parseDouble(new String(mOperand1.getRawValue()));
                double dValue = aD == 0.0 || aD == -0.0 ? Double.NaN : aD / Double.parseDouble(new String(mOperand2.getRawValue()));
                byte[] value = TypedValue.getBytes(dValue);
                return new AtomicValue(value, typeKey);
            }
            case INTEGER: {
                try {
                    int iValue = (int)Double.parseDouble(new String(mOperand1.getRawValue())) / (int)Double.parseDouble(new String(mOperand2.getRawValue()));
                    byte[] value = TypedValue.getBytes(iValue);
                    return new AtomicValue(value, typeKey);
                }
                catch (ArithmeticException e) {
                    throw new XPathError(XPathError.ErrorType.FOAR0001);
                }
            }
            case YEAR_MONTH_DURATION: 
            case DAY_TIME_DURATION: {
                throw new IllegalStateException("Add operator is not implemented for the type " + returnType.getStringRepr() + " yet.");
            }
        }
        throw new XPathError(XPathError.ErrorType.XPTY0004);
    }

    @Override
    protected Type getReturnType(int mOp1, int mOp2) throws SirixXPathException {
        Type type2;
        Type type1;
        try {
            type1 = Type.getType(mOp1).getPrimitiveBaseType();
            type2 = Type.getType(mOp2).getPrimitiveBaseType();
        }
        catch (IllegalStateException e) {
            throw new XPathError(XPathError.ErrorType.XPTY0004);
        }
        if (type1.isNumericType() && type2.isNumericType()) {
            if (type1 == type2) {
                return type1;
            }
            if (type1 == Type.DOUBLE || type2 == Type.DOUBLE) {
                return Type.DOUBLE;
            }
            if (type1 == Type.FLOAT || type2 == Type.FLOAT) {
                return Type.FLOAT;
            }
            assert (type1 == Type.DECIMAL || type2 == Type.DECIMAL);
            return Type.DECIMAL;
        }
        switch (type1) {
            case YEAR_MONTH_DURATION: {
                if (type2 == Type.YEAR_MONTH_DURATION) {
                    return Type.DECIMAL;
                }
                if (!type2.isNumericType()) break;
                return type1;
            }
            case DAY_TIME_DURATION: {
                if (type2 == Type.DAY_TIME_DURATION) {
                    return Type.DECIMAL;
                }
                if (!type2.isNumericType()) break;
                return type1;
            }
            default: {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
        }
        throw new XPathError(XPathError.ErrorType.XPTY0004);
    }
}

