/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.utils;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Compression {
    private static final Logger LOGWRAPPER = LoggerFactory.getLogger(Compression.class);
    public static final int BUFFER_SIZE = 1024;
    private static final Deflater mCompressor = new Deflater();
    private static final Inflater mDecompressor = new Inflater();

    private Compression() {
        throw new AssertionError();
    }

    public static byte[] compress(byte[] toCompress, int level) {
        Preconditions.checkNotNull((Object)toCompress);
        Preconditions.checkArgument((level >= -1 && level <= 9 ? 1 : 0) != 0, (Object)"pLevel must be between 0 and 9!");
        byte[] compressed = new byte[]{};
        mCompressor.setLevel(level);
        mCompressor.reset();
        mCompressor.setInput(toCompress);
        mCompressor.finish();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(toCompress.length);){
            byte[] buf = new byte[1024];
            while (!mCompressor.finished()) {
                int count = mCompressor.deflate(buf);
                bos.write(buf, 0, count);
            }
            compressed = bos.toByteArray();
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), (Throwable)e);
        }
        return compressed;
    }

    public static byte[] decompress(byte[] compressed) {
        Preconditions.checkNotNull((Object)compressed);
        mDecompressor.reset();
        mDecompressor.setInput(compressed);
        byte[] decompressed = new byte[]{};
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressed.length);
        byte[] buf = new byte[1024];
        while (!mDecompressor.finished()) {
            try {
                int count = mDecompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                LOGWRAPPER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        decompressed = bos.toByteArray();
        try {
            bos.close();
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), (Throwable)e);
        }
        return decompressed;
    }
}

