/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.SimulationPreprocessor;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.config.LocalHoverflyConfig;
import io.specto.hoverfly.junit.core.config.RemoteHoverflyConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class HoverflyConfig {
    protected int proxyPort;
    protected int adminPort;
    protected boolean proxyLocalHost;
    protected String destination;
    protected String proxyCaCert;
    protected List<String> captureHeaders;
    protected boolean webServer;
    protected boolean statefulCapture;
    protected boolean incrementalCapture;
    protected SimulationPreprocessor simulationPreprocessor;

    @Deprecated
    public static LocalHoverflyConfig configs() {
        return new LocalHoverflyConfig();
    }

    public static LocalHoverflyConfig localConfigs() {
        return new LocalHoverflyConfig();
    }

    public static RemoteHoverflyConfig remoteConfigs() {
        return new RemoteHoverflyConfig();
    }

    public HoverflyConfig adminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    public HoverflyConfig proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public HoverflyConfig destination(String ... destinations) {
        this.destination = String.join((CharSequence)"|", destinations);
        return this;
    }

    @Deprecated
    public HoverflyConfig proxyLocalHost(boolean proxyLocalHost) {
        if (proxyLocalHost) {
            return this.proxyLocalHost();
        }
        return this;
    }

    public HoverflyConfig proxyLocalHost() {
        this.proxyLocalHost = true;
        return this;
    }

    public HoverflyConfig captureHeaders(String ... headers) {
        this.captureHeaders = Arrays.asList(headers);
        return this;
    }

    public HoverflyConfig captureAllHeaders() {
        this.captureHeaders = Collections.singletonList("*");
        return this;
    }

    public HoverflyConfig enableStatefulCapture() {
        this.statefulCapture = true;
        return this;
    }

    public HoverflyConfig enableIncrementalCapture() {
        this.incrementalCapture = true;
        return this;
    }

    public HoverflyConfig proxyCaCert(String proxyCaCert) {
        this.proxyCaCert = proxyCaCert;
        return this;
    }

    public HoverflyConfig asWebServer() {
        this.webServer = true;
        return this;
    }

    @Deprecated
    public RemoteHoverflyConfig remote() {
        return new RemoteHoverflyConfig();
    }

    public HoverflyConfig simulationPreprocessor(SimulationPreprocessor simulationPreprocessor) {
        this.simulationPreprocessor = simulationPreprocessor;
        return this;
    }

    public abstract HoverflyConfiguration build();
}

