/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.multi;

import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.InterpolationCycleException;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.InterpolationException;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.Interpolator;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.RecursionInterceptor;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.ValueSource;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.interpolation.multi.DelimiterSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiDelimiterStringSearchInterpolator
implements Interpolator {
    private static final int MAX_TRIES = 10;
    private Map existingAnswers = new HashMap();
    private List valueSources = new ArrayList();
    private List postProcessors = new ArrayList();
    private boolean cacheAnswers = false;
    private LinkedHashSet delimiters = new LinkedHashSet();
    private String escapeString;

    public MultiDelimiterStringSearchInterpolator() {
        this.delimiters.add(DelimiterSpecification.DEFAULT_SPEC);
    }

    public MultiDelimiterStringSearchInterpolator addDelimiterSpec(String delimiterSpec) {
        if (delimiterSpec == null) {
            return this;
        }
        this.delimiters.add(DelimiterSpecification.parse(delimiterSpec));
        return this;
    }

    public boolean removeDelimiterSpec(String delimiterSpec) {
        if (delimiterSpec == null) {
            return false;
        }
        return this.delimiters.remove(DelimiterSpecification.parse(delimiterSpec));
    }

    public MultiDelimiterStringSearchInterpolator withValueSource(ValueSource vs) {
        this.addValueSource(vs);
        return this;
    }

    public MultiDelimiterStringSearchInterpolator withPostProcessor(InterpolationPostProcessor postProcessor) {
        this.addPostProcessor(postProcessor);
        return this;
    }

    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void removePostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }

    public String interpolate(String input, String thisPrefixPattern) throws InterpolationException {
        return this.interpolate(input, new SimpleRecursionInterceptor());
    }

    public String interpolate(String input, String thisPrefixPattern, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        return this.interpolate(input, recursionInterceptor);
    }

    public String interpolate(String input) throws InterpolationException {
        return this.interpolate(input, new SimpleRecursionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String interpolate(String input, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        try {
            String string = this.interpolate(input, recursionInterceptor, new HashSet());
            return string;
        }
        finally {
            if (!this.cacheAnswers) {
                this.existingAnswers.clear();
            }
        }
    }

    private String interpolate(String input, RecursionInterceptor recursionInterceptor, Set unresolvable) throws InterpolationException {
        if (input == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(input.length() * 2);
        String lastResult = input;
        int tries = 0;
        do {
            ++tries;
            if (result.length() > 0) {
                lastResult = result.toString();
                result.setLength(0);
            }
            int startIdx = -1;
            int endIdx = -1;
            DelimiterSpecification selectedSpec = null;
            while ((selectedSpec = this.select(input, endIdx)) != null) {
                String startExpr = selectedSpec.getBegin();
                String endExpr = selectedSpec.getEnd();
                startIdx = selectedSpec.getNextStartIndex();
                result.append(input.substring(endIdx + 1, startIdx));
                endIdx = input.indexOf(endExpr, startIdx + 1);
                if (endIdx < 0) break;
                String wholeExpr = input.substring(startIdx, endIdx + endExpr.length());
                String realExpr = wholeExpr.substring(startExpr.length(), wholeExpr.length() - endExpr.length());
                if (startIdx >= 0 && this.escapeString != null && this.escapeString.length() > 0) {
                    String escape;
                    int startEscapeIdx;
                    int n = startEscapeIdx = startIdx == 0 ? 0 : startIdx - this.escapeString.length();
                    if (startEscapeIdx >= 0 && (escape = input.substring(startEscapeIdx, startIdx)) != null && this.escapeString.equals(escape)) {
                        result.append(wholeExpr);
                        result.replace(startEscapeIdx, startEscapeIdx + this.escapeString.length(), "");
                        continue;
                    }
                }
                boolean resolved = false;
                if (!unresolvable.contains(wholeExpr)) {
                    if (realExpr.startsWith(".")) {
                        realExpr = realExpr.substring(1);
                    }
                    if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    recursionInterceptor.expressionResolutionStarted(realExpr);
                    Object value = this.existingAnswers.get(realExpr);
                    Object bestAnswer = null;
                    Iterator it = this.valueSources.iterator();
                    while (it.hasNext() && value == null) {
                        ValueSource vs = (ValueSource)it.next();
                        value = vs.getValue(realExpr);
                        if (value == null || value.toString().indexOf(wholeExpr) <= -1) continue;
                        bestAnswer = value;
                        value = null;
                    }
                    if (value == null && bestAnswer != null) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    if (value != null) {
                        value = this.interpolate(String.valueOf(value), recursionInterceptor, unresolvable);
                        if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
                            it = this.postProcessors.iterator();
                            while (it.hasNext()) {
                                InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)it.next();
                                Object newVal = postProcessor.execute(realExpr, value);
                                if (newVal == null) continue;
                                value = newVal;
                                break;
                            }
                        }
                        result.append(String.valueOf(value));
                        resolved = true;
                    } else {
                        unresolvable.add(wholeExpr);
                    }
                    recursionInterceptor.expressionResolutionFinished(realExpr);
                }
                if (!resolved) {
                    result.append(wholeExpr);
                }
                if (endIdx <= -1) continue;
                endIdx += endExpr.length() - 1;
            }
            if (endIdx == -1 && startIdx > -1) {
                result.append(input.substring(startIdx, input.length()));
                continue;
            }
            if (endIdx >= input.length()) continue;
            result.append(input.substring(endIdx + 1, input.length()));
        } while (!lastResult.equals(result.toString()) && tries < 10);
        return result.toString();
    }

    private DelimiterSpecification select(String input, int lastEndIdx) {
        DelimiterSpecification selected = null;
        Iterator it = this.delimiters.iterator();
        while (it.hasNext()) {
            int idx;
            DelimiterSpecification spec = (DelimiterSpecification)it.next();
            spec.clearNextStart();
            if (selected != null || (idx = input.indexOf(spec.getBegin(), lastEndIdx + 1)) <= -1) continue;
            spec.setNextStartIndex(idx);
            selected = spec;
        }
        return selected;
    }

    public List getFeedback() {
        ArrayList messages = new ArrayList();
        Iterator it = this.valueSources.iterator();
        while (it.hasNext()) {
            ValueSource vs = (ValueSource)it.next();
            List feedback = vs.getFeedback();
            if (feedback == null || feedback.isEmpty()) continue;
            messages.addAll(feedback);
        }
        return messages;
    }

    public void clearFeedback() {
        Iterator it = this.valueSources.iterator();
        while (it.hasNext()) {
            ValueSource vs = (ValueSource)it.next();
            vs.clearFeedback();
        }
    }

    public boolean isCacheAnswers() {
        return this.cacheAnswers;
    }

    public void setCacheAnswers(boolean cacheAnswers) {
        this.cacheAnswers = cacheAnswers;
    }

    public void clearAnswers() {
        this.existingAnswers.clear();
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }

    public MultiDelimiterStringSearchInterpolator setDelimiterSpecs(LinkedHashSet specs) {
        this.delimiters.clear();
        Iterator it = specs.iterator();
        while (it.hasNext()) {
            String spec = (String)it.next();
            if (spec == null) continue;
            this.delimiters.add(DelimiterSpecification.parse(spec));
        }
        return this;
    }
}

