/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.dsl;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import io.spring.gradle.dependencymanagement.dsl.ImportsHandler;
import io.spring.gradle.dependencymanagement.dsl.MavenBomHandler;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardMavenBomHandler;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;

class StandardImportsHandler
extends GroovyObjectSupport
implements ImportsHandler {
    private final DependencyManagementContainer container;
    private final Configuration configuration;

    StandardImportsHandler(DependencyManagementContainer container, Configuration configuration) {
        this.container = container;
        this.configuration = configuration;
    }

    @Override
    public void mavenBom(String coordinates) {
        this.mavenBom(coordinates, (Action<MavenBomHandler>)((Action)null));
    }

    @Override
    public void mavenBom(String coordinates, Closure<?> closure) {
        this.mavenBom(coordinates, (Action<MavenBomHandler>)((Action)mavenBomHandler -> {
            if (closure != null) {
                closure.setDelegate(mavenBomHandler);
                closure.setResolveStrategy(1);
                closure.call();
            }
        }));
    }

    @Override
    public void mavenBom(String coordinates, Action<MavenBomHandler> action) {
        String[] components;
        StandardMavenBomHandler mavenBomHandler = new StandardMavenBomHandler();
        if (action != null) {
            action.execute((Object)mavenBomHandler);
        }
        if ((components = coordinates.split(":")).length != 3) {
            throw new IllegalArgumentException("Bom coordinates must be of the form groupId:artifactId:version");
        }
        this.container.importBom(this.configuration, new Coordinates(components[0], components[1], components[2]), mavenBomHandler.getBomProperties());
    }

    Object propertyMissing(String name) {
        return this.container.getProject().property(name);
    }
}

