/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Dependency;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Parent;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Repository;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.FileModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.InvalidRepositoryException;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.ModelResolver;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.UnresolvableModelException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;

class ConfigurationModelResolver
implements ModelResolver {
    private final Map<String, FileModelSource> pomCache = new HashMap<String, FileModelSource>();
    private final Project project;
    private final DependencyManagementConfigurationContainer configurationContainer;

    ConfigurationModelResolver(Project project, DependencyManagementConfigurationContainer configurationContainer) {
        this.project = project;
        this.configurationContainer = configurationContainer;
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), parent::setVersion);
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency::setVersion);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        return this.resolveModel(groupId, artifactId, version, resolvedVersion -> {});
    }

    private ModelSource resolveModel(String groupId, String artifactId, String version, Consumer<String> versionHandler) {
        String coordinates = groupId + ":" + artifactId + ":" + version + "@pom";
        FileModelSource pom = this.pomCache.get(coordinates);
        if (pom == null) {
            pom = this.resolveModel(coordinates, versionHandler);
            this.pomCache.put(coordinates, pom);
        }
        return pom;
    }

    private FileModelSource resolveModel(String coordinates, Consumer<String> versionHandler) {
        org.gradle.api.artifacts.Dependency dependency = this.project.getDependencies().create((Object)coordinates);
        Configuration configuration = this.configurationContainer.newConfiguration(dependency);
        versionHandler.accept(((ResolvedArtifact)configuration.getResolvedConfiguration().getResolvedArtifacts().iterator().next()).getModuleVersion().getId().getVersion());
        return new FileModelSource((File)configuration.resolve().iterator().next());
    }

    @Override
    public void addRepository(Repository repository) {
    }

    @Override
    public void addRepository(Repository repository, boolean flag) throws InvalidRepositoryException {
    }

    @Override
    public ModelResolver newCopy() {
        return this;
    }
}

