/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.wire;

import com.google.inject.Singleton;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.Parameters;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

@Singleton
final class StringProperties
extends AbstractMap<String, String> {
    private final Map<?, ?> delegate;

    @Inject
    StringProperties(@Parameters Map delegate) {
        this.delegate = delegate;
    }

    @Override
    public String get(Object key) {
        Object value = this.delegate.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        Object value = this.delegate.get(key);
        if (value == null) {
            return this.delegate.containsKey(key);
        }
        return value instanceof String;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<?, ?> e : this.delegate.entrySet()) {
            Object value;
            if (!(e.getKey() instanceof String) || (value = e.getValue()) != null && !(value instanceof String)) continue;
            entries.add(e);
        }
        return entries;
    }
}

