/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.model;

import io.streamzi.openshift.dataflow.model.ProcessorInputPort;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import io.streamzi.openshift.dataflow.model.crds.Processor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessorNodeTemplate {
    private String id = "processor";
    private String name = "Unnamed Processor";
    private String displayName = "Display Name";
    private String description = "A processor node";
    private String transport = "kafka";
    private List<String> inputs = new ArrayList<String>();
    private List<String> outputs = new ArrayList<String>();
    private String mainClassName = "io.streamzi.openshift.container.ProcessorRunner";
    private String imageName = "oc-stream-container";
    private Map<String, String> settings = new HashMap<String, String>();

    public ProcessorNodeTemplate() {
    }

    public ProcessorNodeTemplate(Processor crd) {
        this.setId(crd.getMetadata().getName());
        this.setName(crd.getSpec().getDisplayName());
        this.setDisplayName(crd.getSpec().getDisplayName());
        this.setDescription(crd.getSpec().getDescription());
        this.setTransport("kafka");
        this.setInputs(crd.getSpec().getInputs());
        this.setOutputs(crd.getSpec().getOutputs());
        this.setMainClassName("io.streamzi.openshift.container.crdessorRunner");
        this.setImageName(crd.getSpec().getImageName());
        this.setSettings(crd.getSpec().getSettings());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<String> outputs) {
        this.outputs = outputs;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public void addInput(String name) {
        this.inputs.add(name);
    }

    public void addOutput(String name) {
        this.outputs.add(name);
    }

    public ProcessorNode createProcessorNode() {
        ProcessorNode node = new ProcessorNode();
        node.setImageName(this.imageName);
        node.setSettings(this.settings);
        node.setDisplayName(this.displayName);
        if (this.inputs != null) {
            for (String input : this.inputs) {
                node.addInput(new ProcessorInputPort(input));
            }
        }
        if (this.outputs != null) {
            for (String output : this.outputs) {
                node.addOutput(new ProcessorOutputPort(output));
            }
        }
        return node;
    }
}

