/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.model.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.streamzi.openshift.dataflow.model.ProcessorConstants;
import io.streamzi.openshift.dataflow.model.ProcessorInputPort;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializedNode {
    @JsonIgnore
    private ProcessorNode node;
    private String uuid;
    private String displayName;
    private String templateName;
    private String templateId;
    private String transport;
    private String processorType;
    private List<String> inputs = new ArrayList<String>();
    private List<String> outputs = new ArrayList<String>();
    private String imageName;
    private Map<String, String> settings = new HashMap<String, String>();

    public SerializedNode() {
    }

    public SerializedNode(ProcessorNode node) {
        this.node = node;
        this.displayName = node.getDisplayName();
        this.uuid = node.getUuid();
        this.templateId = node.getTemplateId();
        this.templateName = node.getTemplateName();
        this.transport = node.getTransport();
        this.processorType = node.getProcessorType().toString();
        this.imageName = node.getImageName();
        for (String key : node.getSettings().keySet()) {
            this.settings.put(key, node.getSettings().get(key));
        }
        for (ProcessorOutputPort output : node.getOutputs().values()) {
            this.outputs.add(output.getName());
        }
        for (ProcessorInputPort input : node.getInputs().values()) {
            this.inputs.add(input.getName());
        }
    }

    public ProcessorNode createNode() {
        ProcessorNode node = new ProcessorNode();
        node.setUuid(this.uuid);
        node.setImageName(this.imageName);
        node.setSettings(this.settings);
        node.setTemplateId(this.templateId);
        node.setTemplateName(this.templateName);
        node.setTransport(this.transport);
        node.setProcessorType(ProcessorConstants.ProcessorType.valueOf(this.processorType));
        node.setDisplayName(this.displayName);
        for (String input : this.inputs) {
            node.addInput(new ProcessorInputPort(input));
        }
        for (String output : this.outputs) {
            node.addOutput(new ProcessorOutputPort(output));
        }
        return node;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<String> outputs) {
        this.outputs = outputs;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return "SerializedNode{node=" + this.node + ", displayName='" + this.displayName + '\'' + ", uuid='" + this.uuid + '\'' + ", templateName='" + this.templateName + '\'' + ", templateId='" + this.templateId + '\'' + ", transport='" + this.transport + '\'' + ", processorType='" + this.processorType + '\'' + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", imageName='" + this.imageName + '\'' + ", settings=" + this.settings + '}';
    }
}

