/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.deployment;

import io.streamzi.openshift.dataflow.model.ProcessorLink;

public class LinkDeployment {
    private ProcessorLink link;
    private LinkType type;
    private String sourceCloud;
    private String targetCloud;

    public LinkDeployment(ProcessorLink link, LinkType type, String sourceCloud, String targetCloud) {
        this.link = link;
        this.type = type;
        this.sourceCloud = sourceCloud;
        this.targetCloud = targetCloud;
    }

    public ProcessorLink getLink() {
        return this.link;
    }

    public LinkType getType() {
        return this.type;
    }

    public String getSourceCloud() {
        return this.sourceCloud;
    }

    public String getTargetCloudId() {
        return this.targetCloud;
    }

    public String toString() {
        switch (this.type) {
            case INTERNAL_LINK: {
                return "Internal link from: " + this.link.getSource().getParent().getDisplayName() + " to: " + this.link.getTarget().getParent().getDisplayName() + "{" + this.getTopicName() + "}";
            }
            case REMOTE_LINK: {
                return "Remote link: [" + this.sourceCloud + "]" + this.link.getSource().getParent().getDisplayName() + " to: [" + this.targetCloud + "] " + this.link.getTarget().getParent().getDisplayName() + "{" + this.getTopicName() + "}";
            }
        }
        return "UNDEFINED LINK";
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkDeployment) {
            LinkDeployment other = (LinkDeployment)obj;
            if (other.getType() != this.type) {
                return false;
            }
            return other.getSourceCloud().equals(this.sourceCloud) && other.getTargetCloudId().equals(this.targetCloud);
        }
        return false;
    }

    public String getTopicName() {
        String flowName = this.link.getSource().getParent().getParent().getName();
        return flowName + "-" + this.link.getSource().getParent().getUuid() + "-" + this.link.getSource().getName();
    }

    public static enum LinkType {
        INTERNAL_LINK,
        REMOTE_LINK;

    }
}

