/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.model;

import io.streamzi.openshift.dataflow.model.ProcessorInputPort;
import io.streamzi.openshift.dataflow.model.ProcessorLink;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import io.streamzi.openshift.dataflow.serialization.SerializedFlow;
import io.streamzi.openshift.dataflow.serialization.SerializedNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ProcessorFlow
implements Serializable {
    private List<ProcessorNode> nodes = new ArrayList<ProcessorNode>();
    private String name;
    private Map<String, String> settings = new HashMap<String, String>();
    private Map<String, String> globalSettings = new HashMap<String, String>();

    public ProcessorFlow() {
    }

    public ProcessorFlow(SerializedFlow flow) {
        this.setName(flow.getName());
        flow.getNodes().stream().map(SerializedNode::createNode).forEach(this::addProcessorNode);
        flow.getLinks().forEach(link -> this.linkNodes(link.getSourceUuid(), link.getSourcePortName(), link.getTargetUuid(), link.getTargetPortName()));
        flow.getSettings().keySet().forEach(key -> this.getSettings().put((String)key, flow.getSettings().get(key)));
        flow.getGlobalSettings().keySet().forEach(key -> this.getGlobalSettings().put((String)key, flow.getGlobalSettings().get(key)));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getGlobalSettings() {
        return this.globalSettings;
    }

    public void setGlobalSettings(Map<String, String> globalSettings) {
        this.globalSettings = globalSettings;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public List<ProcessorNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ProcessorNode> nodes) {
        this.nodes = nodes;
    }

    public void addProcessorNode(ProcessorNode node) {
        if (node.getUuid() == null || node.getUuid().isEmpty()) {
            node.setUuid(UUID.randomUUID().toString());
        }
        node.setParent(this);
        this.nodes.add(node);
    }

    public void linkNodes(String sourceUuid, String sourcePortName, String targetUuid, String targetPortName) {
        this.linkNodes(this.getNodeByUuid(sourceUuid), sourcePortName, this.getNodeByUuid(targetUuid), targetPortName);
    }

    public void linkNodes(ProcessorNode source, String sourcePortName, ProcessorNode target, String targetPortName) {
        ProcessorOutputPort sourcePort = source.getOutput(sourcePortName);
        ProcessorInputPort targetPort = target.getInput(targetPortName);
        if (sourcePort != null && targetPort != null) {
            ProcessorLink link = new ProcessorLink();
            link.setSource(sourcePort);
            link.setTarget(targetPort);
            sourcePort.addLink(link);
            targetPort.addLink(link);
        }
    }

    public List<ProcessorLink> getLinks() {
        ArrayList<ProcessorLink> links = new ArrayList<ProcessorLink>();
        for (ProcessorNode n : this.nodes) {
            for (ProcessorOutputPort output : n.getOutputs().values()) {
                for (ProcessorLink link : output.getLinks()) {
                    links.add(link);
                }
            }
        }
        return links;
    }

    public ProcessorNode getNodeByUuid(String uuid) {
        for (ProcessorNode n : this.nodes) {
            if (!n.getUuid().equals(uuid)) continue;
            return n;
        }
        return null;
    }
}

