/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.cloudevents.kafka.util;

import io.streamzi.cloudevents.CloudEvent;
import io.streamzi.cloudevents.CloudEventBuilder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.aerogear.kafka.serialization.CafdiSerdes;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public final class KafkaHeaderUtil {
    private KafkaHeaderUtil() {
    }

    public static Headers extractHeaders(CloudEvent<?> ce) {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("eventType", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, (Object)ce.getEventType())));
        headers.add((Header)new RecordHeader("cloudEventsVersion", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, (Object)ce.getCloudEventsVersion())));
        headers.add((Header)new RecordHeader("source", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, (Object)ce.getSource().toString())));
        headers.add((Header)new RecordHeader("eventID", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, (Object)ce.getEventID())));
        if (ce.getEventTypeVersion().isPresent()) {
            headers.add((Header)new RecordHeader("eventTypeVersion", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, ce.getEventTypeVersion().get())));
        }
        if (ce.getSchemaURL().isPresent()) {
            headers.add((Header)new RecordHeader("schemaURL", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, (Object)((URI)ce.getSchemaURL().get()).toString())));
        }
        if (ce.getContentType().isPresent()) {
            headers.add((Header)new RecordHeader("contentType", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, ce.getContentType().get())));
        }
        if (ce.getEventTime().isPresent()) {
            headers.add((Header)new RecordHeader("eventTime", CafdiSerdes.serdeFrom(String.class).serializer().serialize(null, (Object)((ZonedDateTime)ce.getEventTime().get()).toString())));
        }
        return headers;
    }

    public static <K, V> CloudEvent<Map<K, V>> createFromConsumerRecord(ConsumerRecord<K, V> record) {
        Headers headers = record.headers();
        CloudEventBuilder builder = new CloudEventBuilder();
        try {
            builder.eventType((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("eventType").value()));
            builder.cloudEventsVersion((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("cloudEventsVersion").value()));
            builder.source(URI.create((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("source").value())));
            builder.eventID((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("eventID").value()));
            if (headers.lastHeader("eventTime") != null) {
                builder.eventTime(ZonedDateTime.parse((CharSequence)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("eventTime").value()), DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
            if (headers.lastHeader("eventTypeVersion") != null) {
                builder.eventTypeVersion((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("eventTypeVersion").value()));
            }
            if (headers.lastHeader("schemaURL") != null) {
                builder.schemaURL(URI.create((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("schemaURL").value())));
            }
            HashMap<Object, Object> rawKafkaRecord = new HashMap<Object, Object>();
            rawKafkaRecord.put(record.key(), record.value());
            builder.data(rawKafkaRecord);
            if (headers.lastHeader("contentType") != null) {
                builder.contentType((String)CafdiSerdes.serdeFrom(String.class).deserializer().deserialize(null, headers.lastHeader("contentType").value()));
            } else {
                builder.contentType("application/ce-kafka-data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }
}

