/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.reflect;

import io.sundr.FunctionFactory;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AttributeKey;
import io.sundr.model.Attributeable;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.Kind;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.Modifiers;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.repo.DefinitionRepository;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassTo {
    private static final String ARGUMENT_PREFIX = "arg";
    private static final Set<Class> references = new HashSet<Class>();
    public static final Function<Class, Kind> KIND = FunctionFactory.cache((Function)new Function<Class, Kind>(){

        @Override
        public Kind apply(Class item) {
            if (item.isAnnotation()) {
                return Kind.ANNOTATION;
            }
            if (item.isEnum()) {
                return Kind.ENUM;
            }
            if (item.isInterface()) {
                return Kind.INTERFACE;
            }
            return Kind.CLASS;
        }
    });
    public static final Function<Type, TypeRef> TYPEREF = FunctionFactory.cache((Function)new Function<Type, TypeRef>(){

        @Override
        public TypeRef apply(Type item) {
            if (item == null) {
                return new VoidRefBuilder().build();
            }
            if (item instanceof WildcardType) {
                return ((WildcardRefBuilder)new WildcardRefBuilder().withBounds(Arrays.asList(((WildcardType)item).getLowerBounds()).stream().map(t -> TYPEREF.apply((Type)t)).collect(Collectors.toList()))).build();
            }
            if (item instanceof TypeVariable) {
                return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(((TypeVariable)item).getName())).build();
            }
            if (item instanceof GenericArrayType) {
                Type target = item;
                int dimensions = 0;
                while (target instanceof GenericArrayType) {
                    target = ((GenericArrayType)target).getGenericComponentType();
                    ++dimensions;
                }
                if (target instanceof Class) {
                    references.add((Class)target);
                }
                TypeRef targetRef = TYPEREF.apply(target);
                return targetRef.withDimensions(dimensions + targetRef.getDimensions());
            }
            if (item instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)item;
                Type rawType = parameterizedType.getRawType();
                ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
                for (Type arg : parameterizedType.getActualTypeArguments()) {
                    arguments.add(TYPEREF.apply(arg));
                    if (!(arg instanceof Class)) continue;
                    references.add((Class)arg);
                }
                if (rawType instanceof Class) {
                    references.add((Class)rawType);
                }
                return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)TYPEREF.apply(rawType)).withArguments(arguments)).build();
            }
            if (Object.class.equals((Object)item)) {
                return ClassRef.OBJECT;
            }
            if (item instanceof Class) {
                Class<?> c = (Class<?>)item;
                if (c.isArray()) {
                    Class<?> target = c;
                    int dimensions = 0;
                    while (target.isArray()) {
                        target = target.getComponentType();
                        ++dimensions;
                    }
                    TypeRef targetRef = TYPEREF.apply(target);
                    references.add(target);
                    return targetRef.withDimensions(dimensions + targetRef.getDimensions());
                }
                if (c.isPrimitive()) {
                    return ((PrimitiveRefBuilder)((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName(c.getName())).withDimensions(0)).build();
                }
                ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
                for (TypeVariable v : c.getTypeParameters()) {
                    arguments.add(TYPEREF.apply(v));
                }
                references.add((Class)item);
                String fqcn = c.getName().replaceAll(Pattern.quote("$"), ".");
                return ((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(fqcn)).withArguments(arguments)).build();
            }
            throw new IllegalArgumentException("Can't convert type:" + item + " to a TypeRef");
        }
    });
    public static final Function<Class<? extends Annotation>, AnnotationRef> ANNOTATIONTYPEREF = FunctionFactory.cache(item -> {
        ClassRef classRef = (ClassRef)TYPEREF.apply((Type)item);
        return ((AnnotationRefBuilder)new AnnotationRefBuilder().withClassRef(classRef)).build();
    });
    private static final Function<Class, TypeDef> INTERNAL_TYPEDEF = new Function<Class, TypeDef>(){

        @Override
        public TypeDef apply(Class item) {
            if (Object.class.equals((Object)item)) {
                return TypeDef.OBJECT;
            }
            Kind kind = KIND.apply(item);
            ArrayList<ClassRef> extendsList = new ArrayList<ClassRef>();
            ArrayList<ClassRef> implementsList = new ArrayList<ClassRef>();
            ArrayList properties = new ArrayList();
            ArrayList methods = new ArrayList();
            ArrayList constructors = new ArrayList();
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            if (item.getSuperclass() != null) {
                extendsList.add((ClassRef)TYPEREF.apply(item.getGenericSuperclass()));
                references.add(item.getSuperclass());
            }
            for (Class<?> clazz : item.getInterfaces()) {
                references.add(clazz);
            }
            for (Type type : item.getGenericInterfaces()) {
                TypeRef ref = TYPEREF.apply(type);
                if (!(ref instanceof ClassRef)) continue;
                implementsList.add((ClassRef)ref);
            }
            constructors.addAll(ClassTo.getConstructors(item, references));
            methods.addAll(ClassTo.getMethods(item, references));
            properties.addAll(ClassTo.getProperties(item, references));
            for (Type type : item.getTypeParameters()) {
                ArrayList<ClassRef> bounds = new ArrayList<ClassRef>();
                for (Type boundType : type.getBounds()) {
                    TypeRef typeRef = TYPEREF.apply(boundType);
                    if (!(typeRef instanceof ClassRef)) continue;
                    bounds.add((ClassRef)typeRef);
                }
                parameters.add(((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(type.getName())).withBounds(bounds)).build());
            }
            String outerFQCN = item.getDeclaringClass() != null ? item.getDeclaringClass().getName() : null;
            TypeDef result = DefinitionRepository.getRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withOuterTypeName(outerFQCN)).withName(item.getSimpleName())).withPackageName(item.getPackage() != null ? item.getPackage().getName() : null)).withModifiers(Modifiers.from((int)item.getModifiers()))).withParameters(parameters)).withConstructors(constructors)).withMethods(methods)).withProperties(properties)).withExtendsList(extendsList)).withImplementsList(implementsList)).build());
            HashSet copy = new HashSet(references);
            copy.stream().peek(c -> references.remove(c)).filter(c -> !c.equals(item)).filter(c -> !c.getName().startsWith("sun.") && !c.getName().toString().startsWith("com.sun.")).forEach(c -> {
                String referenceFQCN = c.getName().replaceAll(Pattern.quote("$"), ".");
                DefinitionRepository.getRepository().registerIfAbsent(referenceFQCN, () -> this.apply((Class)c));
            });
            return result;
        }
    };
    public static final Function<Class, TypeDef> TYPEDEF = INTERNAL_TYPEDEF;
    private static Function<Type, TypeParamDef> TYPEPARAMDEF = FunctionFactory.cache((Function)new Function<Type, TypeParamDef>(){

        @Override
        public TypeParamDef apply(Type item) {
            if (item instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)item;
                String name = typeVariable.getName();
                ArrayList<ClassRef> bounds = new ArrayList<ClassRef>();
                for (Type b : typeVariable.getBounds()) {
                    if (!(b instanceof Class)) continue;
                    Class c = (Class)b;
                    bounds.add((ClassRef)TYPEREF.apply(c));
                }
                return ((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(name)).withBounds(bounds)).build();
            }
            return null;
        }
    });

    private static Set<Property> getProperties(Class item, Set<Class> references) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Field field : item.getDeclaredFields()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            ClassTo.processAnnotatedElement(field, annotationRefs);
            if (field.getGenericType() instanceof Class) {
                references.add((Class)field.getGenericType());
            }
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)field.getGenericType();
                references.addAll(Stream.of(p.getActualTypeArguments()).filter(t -> t instanceof Class).map(t -> (Class)t).filter(c -> !item.equals(c)).collect(Collectors.toList()));
            }
            properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(field.getName())).withModifiers(Modifiers.from((int)field.getModifiers()))).withEnumConstant(field.isEnumConstant())).withSynthetic(field.isSynthetic())).withAnnotations(annotationRefs)).withTypeRef(TYPEREF.apply(field.getGenericType()))).build());
        }
        return properties;
    }

    private static void processAnnotatedElement(AnnotatedElement field, List<AnnotationRef> annotationRefs) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            AnnotationRef annotationRef = ANNOTATIONTYPEREF.apply(annotationType);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (java.lang.reflect.Method method : annotationType.getDeclaredMethods()) {
                String name = method.getName();
                try {
                    Object value = method.invoke((Object)annotation, (Object[])null);
                    parameters.put(name, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (annotationType.getName().startsWith("jdk.")) continue;
                    System.out.printf("Couldn't retrieve '%s' parameter value for %s%n", name, annotationType.getName());
                }
            }
            annotationRef = ((AnnotationRefBuilder)new AnnotationRefBuilder(annotationRef).withParameters(parameters)).build();
            annotationRefs.add(annotationRef);
        }
    }

    private static Set<Method> getConstructors(Class item, Set<Class> references) {
        HashSet<Method> constructors = new HashSet<Method>();
        for (Constructor<?> constructor : item.getDeclaredConstructors()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            ArrayList<ClassRef> exceptionRefs = new ArrayList<ClassRef>();
            ArrayList<Property> arguments = new ArrayList<Property>();
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            ClassTo.processMethod(references, constructor, annotationRefs, exceptionRefs, arguments, parameters);
            constructors.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(constructor.getName())).withModifiers(Modifiers.from((int)constructor.getModifiers()))).withArguments(arguments)).withParameters(parameters)).withAnnotations(annotationRefs)).withExceptions(exceptionRefs)).build());
        }
        return constructors;
    }

    private static Set<Method> getMethods(Class item, Set<Class> references) {
        HashSet<Method> methods = new HashSet<Method>();
        for (java.lang.reflect.Method method : item.getDeclaredMethods()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            ArrayList<ClassRef> exceptionRefs = new ArrayList<ClassRef>();
            ArrayList<Property> arguments = new ArrayList<Property>();
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            ClassTo.processMethod(references, method, annotationRefs, exceptionRefs, arguments, parameters);
            HashMap<AttributeKey, String> attributes = new HashMap<AttributeKey, String>();
            if (method.getDefaultValue() != null) {
                attributes.put(Attributeable.DEFAULT_VALUE, String.valueOf(method.getDefaultValue()));
            }
            methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(method.getName())).withDefaultMethod(method.isDefault())).withModifiers(Modifiers.from((int)method.getModifiers()))).withReturnType(TYPEREF.apply(method.getReturnType()))).withArguments(arguments)).withParameters(parameters)).withExceptions(exceptionRefs)).withAnnotations(annotationRefs)).withAttributes(attributes)).build());
        }
        return methods;
    }

    private static void processMethod(Set<Class> references, Executable method, List<AnnotationRef> annotationRefs, List<ClassRef> exceptionRefs, List<Property> arguments, List<TypeParamDef> parameters) {
        ClassTo.processAnnotatedElement(method, annotationRefs);
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            exceptionRefs.add((ClassRef)TYPEREF.apply(exceptionType));
        }
        for (int i = 1; i <= method.getGenericParameterTypes().length; ++i) {
            Type argumentType = method.getGenericParameterTypes()[i - 1];
            arguments.add(((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(ARGUMENT_PREFIX + i)).withTypeRef(TYPEREF.apply(argumentType))).build());
            if (!(argumentType instanceof Class)) continue;
            references.add((Class)argumentType);
        }
        for (Type type : method.getGenericParameterTypes()) {
            TypeParamDef typeParamDef = TYPEPARAMDEF.apply(type);
            if (typeParamDef == null) continue;
            parameters.add(typeParamDef);
        }
    }
}

