/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.api;

import io.sundr.SundrException;
import io.sundr.codegen.api.Identifier;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.StreamSupport;

public class Identifiers {
    private static Identifier SCOPE;

    public static <T> Optional<Identifier<T>> findIdentifier(Class<T> type) {
        return StreamSupport.stream(ServiceLoader.load(Identifier.class, Identifier.class.getClassLoader()).spliterator(), false).filter(r -> r.getType().isAssignableFrom(type)).map(r -> r).findFirst();
    }

    public static synchronized Identifier getIdentifier() {
        return SCOPE;
    }

    public static <T> WithIdentifier withIdentifier(final Function<T, String> identifier) {
        return Identifiers.withIdentifier(new Identifier<T>(){

            @Override
            public Class<T> getType() {
                return Class.class;
            }

            @Override
            public Function<T, String> getFunction() {
                return identifier;
            }
        });
    }

    public static WithIdentifier withIdentifier(Identifier identifier) {
        return new WithIdentifier(identifier);
    }

    public static class WithIdentifier {
        private final Identifier identifier;

        public WithIdentifier(Identifier identifier) {
            this.identifier = identifier;
        }

        public synchronized <V> V apply(Function<Identifier, V> function) {
            try {
                SCOPE = this.identifier;
                V v = function.apply(this.identifier);
                return v;
            }
            catch (Exception e) {
                throw new SundrException((Throwable)e);
            }
            finally {
                SCOPE = null;
            }
        }

        public synchronized <V> V call(Callable<V> callable) {
            try {
                SCOPE = this.identifier;
                V v = callable.call();
                return v;
            }
            catch (Exception e) {
                throw new SundrException((Throwable)e);
            }
            finally {
                SCOPE = null;
            }
        }
    }
}

