/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Property;
import io.sundr.model.TypeRef;

public class Cast
implements Expression {
    private final TypeRef type;
    private final Expression expression;

    public Cast(TypeRef type, Expression expression) {
        this.type = type;
        this.expression = expression;
    }

    public Cast(Class type, Expression expression) {
        this(ClassRef.forClass(type), expression);
    }

    public Cast(Class type, Property property) {
        this(ClassRef.forClass(type), (Expression)property.toReference());
    }

    public Expression getExpression() {
        return this.expression;
    }

    public TypeRef getType() {
        return this.type;
    }

    @Override
    public String render() {
        return "(" + this.type.render() + ") " + this.expression.render();
    }
}

