/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.GreaterThan;
import io.sundr.model.GreaterThanOrEqual;
import io.sundr.model.IfDslConditionStep;
import io.sundr.model.LessThan;
import io.sundr.model.LessThanOrEqual;
import io.sundr.model.Statement;
import java.util.Optional;

public class If
implements Statement {
    private final Expression condition;
    private final Statement statement;
    private final Optional<Statement> elseStatement;

    public If(Expression condition, Statement statement, Optional<Statement> elseStatement) {
        this.condition = condition;
        this.statement = statement;
        this.elseStatement = elseStatement;
    }

    public If(Expression condition, Statement statement, Statement elseStatement) {
        this(condition, statement, Optional.ofNullable(elseStatement));
    }

    public If(Expression condition, Statement statement) {
        this(condition, statement, Optional.empty());
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Optional<Statement> getElseStatement() {
        return this.elseStatement;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("if").append(" ").append("(").append(this.condition.renderExpression()).append(")").append(" ").append("{").append("\n");
        sb.append(this.tab(this.statement.renderStatement()));
        sb.append("}");
        this.elseStatement.ifPresent(e -> {
            sb.append(" else ");
            if (e instanceof If) {
                sb.append(e.render());
            } else {
                sb.append("{");
                sb.append("\n");
                sb.append(this.tab(e.renderStatement()));
                sb.append("}");
            }
        });
        sb.append("\n");
        return sb.toString();
    }

    public static IfDslConditionStep condition(Expression condition) {
        return new IfDslConditionStep(condition);
    }

    public static IfDslConditionStep not(Expression condition) {
        return new IfDslConditionStep(Expression.not(condition));
    }

    public static IfDslConditionStep eq(Expression left, Expression right) {
        return new IfDslConditionStep(Expression.eq(left, right));
    }

    public static IfDslConditionStep ge(Expression left, Expression right) {
        return new IfDslConditionStep(new GreaterThanOrEqual(left, right));
    }

    public static IfDslConditionStep gt(Expression left, Expression right) {
        return new IfDslConditionStep(new GreaterThan(left, right));
    }

    public static IfDslConditionStep le(Expression left, Expression right) {
        return new IfDslConditionStep(new LessThanOrEqual(left, right));
    }

    public static IfDslConditionStep lt(Expression left, Expression right) {
        return new IfDslConditionStep(new LessThan(left, right));
    }

    public static IfDslConditionStep ne(Expression left, Expression right) {
        return new IfDslConditionStep(Expression.ne(left, right));
    }

    public static IfDslConditionStep isNull(Expression expr) {
        return new IfDslConditionStep(Expression.isNull(expr));
    }

    public static IfDslConditionStep notNull(Expression expr) {
        return new IfDslConditionStep(Expression.notNull(expr));
    }
}

