/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.AttributeKey;
import io.sundr.model.AttributeSupport;
import io.sundr.model.ClassRef;
import io.sundr.model.Renderable;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeParamRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeParamDef
extends AttributeSupport
implements Renderable {
    private final String name;
    private final List<ClassRef> bounds;

    public TypeParamDef(String name, List<ClassRef> bounds, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.name = name;
        this.bounds = bounds == null || bounds.isEmpty() ? Collections.emptyList() : bounds.stream().filter(b -> !b.getFullyQualifiedName().equals(TypeDef.OBJECT.getFullyQualifiedName())).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public List<ClassRef> getBounds() {
        return this.bounds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParamDef that = (TypeParamDef)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.bounds != null ? this.bounds.equals(that.bounds) : that.bounds == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.bounds != null ? this.bounds.hashCode() : 0);
        return result;
    }

    public TypeParamRef toReference() {
        return new TypeParamRef(this.name, 0, this.getAttributes());
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.bounds != null && !this.bounds.isEmpty()) {
            sb.append(" extends ");
            sb.append(this.bounds.stream().map(Renderable::render).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.bounds != null && !this.bounds.isEmpty()) {
            sb.append(" extends ");
            sb.append(this.bounds.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }
}

