/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.Expression;
import io.sundr.model.GreaterThan;
import io.sundr.model.GreaterThanOrEqual;
import io.sundr.model.LessThan;
import io.sundr.model.LessThanOrEqual;
import io.sundr.model.Statement;
import java.util.List;

public class While
implements Statement {
    private final Expression condition;
    private final Statement statement;

    public While(Expression condition, Statement statement) {
        this.condition = condition;
        this.statement = statement;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("while").append(" ").append("(").append(this.condition.render()).append(")").append(" ").append("{").append("\n");
        sb.append(this.tab(this.statement.renderStatement()));
        sb.append("}").append("\n");
        return sb.toString();
    }

    public static DslConditionStep condition(Expression condition) {
        return new DslConditionStep(condition);
    }

    public static DslConditionStep eq(Expression left, Expression right) {
        return new DslConditionStep(Expression.eq(left, right));
    }

    public static DslConditionStep ge(Expression left, Expression right) {
        return new DslConditionStep(new GreaterThanOrEqual(left, right));
    }

    public static DslConditionStep gt(Expression left, Expression right) {
        return new DslConditionStep(new GreaterThan(left, right));
    }

    public static DslConditionStep le(Expression left, Expression right) {
        return new DslConditionStep(new LessThanOrEqual(left, right));
    }

    public static DslConditionStep lt(Expression left, Expression right) {
        return new DslConditionStep(new LessThan(left, right));
    }

    public static DslConditionStep ne(Expression left, Expression right) {
        return new DslConditionStep(Expression.ne(left, right));
    }

    public static DslConditionStep isNull(Expression expr) {
        return new DslConditionStep(Expression.isNull(expr));
    }

    public static DslConditionStep notNull(Expression expr) {
        return new DslConditionStep(Expression.notNull(expr));
    }

    public static class DslConditionStep {
        private Expression condition;

        DslConditionStep(Expression condition) {
            this.condition = condition;
        }

        public While body(Statement ... statements) {
            return new While(this.condition, Block.wrap(statements));
        }

        public While body(List<Statement> statements) {
            return new While(this.condition, Block.wrap(statements));
        }
    }
}

