/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Block
implements Statement {
    private List<Statement> statements;

    public Block(List<Statement> statements) {
        this.statements = statements;
    }

    public Block(Statement ... statements) {
        this.statements = Arrays.asList(statements);
    }

    public static Statement wrap(List<Statement> statements) {
        if (statements == null || statements.isEmpty()) {
            return new Block(new Statement[0]);
        }
        if (statements.size() == 1) {
            return statements.get(0);
        }
        return new Block(statements);
    }

    public static Statement wrap(Statement ... statements) {
        if (statements == null || statements.length == 0) {
            return new Block(new Statement[0]);
        }
        if (statements.length == 1) {
            return statements[0];
        }
        return new Block(statements);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        for (Statement statement : this.statements) {
            refs.addAll(statement.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        for (Statement statement : this.statements) {
            sb.append(this.tab(statement.renderStatement()));
        }
        return sb.toString();
    }
}

