/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Cast;
import io.sundr.model.ClassRef;
import io.sundr.model.Construct;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Property;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Declare
implements ExpressionOrStatement {
    private final List<Property> properties;
    private final Optional<Expression> value;

    public Declare(List<Property> properties, Optional<Expression> value) {
        this.properties = properties;
        this.value = value;
    }

    public Declare(Property property, Expression expression) {
        this(Arrays.asList(property), Optional.of(expression));
    }

    public Declare(Property property, Object value, Object ... rest) {
        this(Arrays.asList(property), Optional.of(ValueRef.from(value, rest)));
    }

    public Declare(Property property, Property valueProperty) {
        this(Arrays.asList(property), Optional.of(valueProperty));
    }

    public Declare(Property property) {
        this.properties = Arrays.asList(property);
        this.value = Optional.empty();
    }

    public Declare(Class type, String name) {
        this.properties = Arrays.asList(Property.newProperty(ClassRef.forName(type.getName()), name));
        this.value = Optional.empty();
    }

    public Declare(Class type, String name, Object value) {
        this.properties = Arrays.asList(Property.newProperty(ClassRef.forClass(type), name));
        this.value = Optional.of(ValueRef.from(value, new Object[0]));
    }

    public static Declare newInstance(String name, Class type, Expression ... arguments) {
        if (arguments.length == 0) {
            return new Declare(Property.newProperty(ClassRef.forClass(type), name), new Construct(type, new Expression[0]));
        }
        if (arguments.length == 1) {
            return new Declare(Property.newProperty(ClassRef.forClass(type), name), new Construct(type, arguments[0]));
        }
        return new Declare(Property.newProperty(ClassRef.forClass(type), name), new Construct(type, arguments));
    }

    public static Declare newInstance(String name, ClassRef type, Expression ... arguments) {
        if (arguments.length == 0) {
            return new Declare(Property.newProperty(type, name), new Construct(type, new Expression[0]));
        }
        if (arguments.length == 1) {
            return new Declare(Property.newProperty(type, name), new Construct(type, arguments[0]));
        }
        return new Declare(Property.newProperty(type, name), new Construct(type, arguments));
    }

    public static Declare cast(String name, ClassRef type, Expression target) {
        return new Declare(Property.newProperty(type, name), new Cast(type, target));
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        for (Property property : this.properties) {
            refs.addAll(property.getReferences());
        }
        this.value.ifPresent(v -> refs.addAll(v.getReferences()));
        return refs;
    }

    @Override
    public String render() {
        return this.renderExpression();
    }

    @Override
    public String renderExpression() {
        StringBuilder sb = new StringBuilder();
        TypeRef typeRef = this.properties.get(0).getTypeRef();
        sb.append(typeRef.render());
        sb.append(" ");
        sb.append(this.properties.stream().map(Property::getName).collect(Collectors.joining(", ")));
        sb.append(this.value.map(v -> " = " + v.renderExpression()).orElse(""));
        return sb.toString();
    }
}

