/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Return;
import io.sundr.model.Statement;
import io.sundr.model.SwitchDslExpressionStep;
import io.sundr.model.ValueRef;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Switch
implements Statement {
    private final Expression expression;
    private final Map<ValueRef, Block> cases;
    private final Optional<Block> defaultCase;

    public Switch(Expression expression, Map<ValueRef, Block> cases, Optional<Block> defaultCase) {
        this.expression = expression;
        this.cases = cases;
        this.defaultCase = defaultCase;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Map<ValueRef, Block> getCases() {
        return this.cases;
    }

    public Optional<Block> getDefaultCase() {
        return this.defaultCase;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.expression != null) {
            refs.addAll(this.expression.getReferences());
        }
        if (this.cases != null) {
            for (Map.Entry<ValueRef, Block> entry : this.cases.entrySet()) {
                if (entry.getKey() != null) {
                    refs.addAll(entry.getKey().getReferences());
                }
                if (entry.getValue() == null) continue;
                refs.addAll(entry.getValue().getReferences());
            }
        }
        this.defaultCase.ifPresent(d -> refs.addAll(d.getReferences()));
        return refs;
    }

    private static boolean blockReturns(Block block) {
        return block.getStatements().stream().anyMatch(s -> s instanceof Return);
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch");
        sb.append(" ");
        sb.append("(");
        sb.append(this.expression.renderExpression());
        sb.append(")");
        sb.append(" ");
        sb.append("{");
        for (Map.Entry<ValueRef, Block> entry : this.cases.entrySet()) {
            sb.append("\n");
            sb.append(this.tab("case " + entry.getKey().render() + ":"));
            sb.append("\n");
            sb.append(this.tab(this.tab(entry.getValue().render())));
            if (Switch.blockReturns(entry.getValue())) continue;
            sb.append("\n");
            sb.append(this.tab(this.tab("break;")));
        }
        this.defaultCase.ifPresent(d -> {
            sb.append("\n");
            sb.append(this.tab("default:"));
            sb.append("\n");
            sb.append(this.tab(this.tab(d.render())));
        });
        sb.append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static SwitchDslExpressionStep expression(Expression expression) {
        return new SwitchDslExpressionStep(expression);
    }
}

