/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import java.util.HashSet;
import java.util.Set;

public class Ternary
implements Expression {
    private Expression condition;
    private Expression result;
    private Expression alternative;

    public Ternary(Expression condition, Expression result, Expression alternative) {
        this.condition = condition;
        this.result = result;
        this.alternative = alternative;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getResult() {
        return this.result;
    }

    public Expression getAlternative() {
        return this.alternative;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.condition != null) {
            refs.addAll(this.condition.getReferences());
        }
        if (this.result != null) {
            refs.addAll(this.result.getReferences());
        }
        if (this.alternative != null) {
            refs.addAll(this.alternative.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.condition.renderExpression()).append(" ? ").append(this.result.renderExpression()).append(" : ").append(this.alternative.renderExpression());
        return sb.toString();
    }
}

