/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Property;
import io.sundr.model.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class Try
implements Statement {
    private final List<Statement> resources;
    private final Block tryBlock;
    private final List<Catch> catchBlocks;
    private final Optional<Block> finallyBlock;

    public Try(Block tryBlock, List<Catch> catchBlocks, Optional<Block> finallyBlock) {
        this(Collections.emptyList(), tryBlock, catchBlocks, finallyBlock);
    }

    public Try(List<Statement> resources, Block tryBlock, List<Catch> catchBlocks, Optional<Block> finallyBlock) {
        this.resources = resources;
        this.tryBlock = tryBlock;
        this.catchBlocks = catchBlocks;
        this.finallyBlock = finallyBlock;
    }

    public List<Statement> getResources() {
        return this.resources;
    }

    public Block getTryBlock() {
        return this.tryBlock;
    }

    public List<Catch> getCatchBlocks() {
        return this.catchBlocks;
    }

    public Optional<Block> getFinallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.resources != null) {
            for (Statement resource : this.resources) {
                if (resource == null) continue;
                refs.addAll(resource.getReferences());
            }
        }
        if (this.tryBlock != null) {
            refs.addAll(this.tryBlock.getReferences());
        }
        if (this.catchBlocks != null) {
            for (Catch catchBlock : this.catchBlocks) {
                if (catchBlock == null) continue;
                refs.addAll(catchBlock.getReferences());
            }
        }
        this.finallyBlock.ifPresent(block -> refs.addAll(block.getReferences()));
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("try");
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append(" ");
            sb.append("(");
            for (int i = 0; i < this.resources.size(); ++i) {
                if (i > 0) {
                    sb.append(";");
                    sb.append(" ");
                }
                sb.append(this.resources.get(i).render());
            }
            sb.append(")");
        }
        sb.append(" ");
        sb.append(this.tryBlock.render());
        for (Catch catchBlock : this.catchBlocks) {
            sb.append(" ");
            sb.append(catchBlock.render());
        }
        this.finallyBlock.ifPresent(block -> {
            sb.append(" ");
            sb.append("finally");
            sb.append(" ");
            sb.append(block.render());
        });
        return sb.toString();
    }

    public static class Catch {
        private final Property parameter;
        private final Block block;

        public Catch(Property parameter, Block block) {
            this.parameter = parameter;
            this.block = block;
        }

        public Property getParameter() {
            return this.parameter;
        }

        public Block getBlock() {
            return this.block;
        }

        public Set<ClassRef> getReferences() {
            HashSet<ClassRef> refs = new HashSet<ClassRef>();
            if (this.parameter != null) {
                refs.addAll(this.parameter.getReferences());
            }
            if (this.block != null) {
                refs.addAll(this.block.getReferences());
            }
            return refs;
        }

        public String render() {
            StringBuilder sb = new StringBuilder();
            sb.append("catch");
            sb.append(" ");
            sb.append("(");
            sb.append(this.parameter.render());
            sb.append(")");
            sb.append(" ");
            sb.append(this.block.render());
            return sb.toString();
        }
    }
}

