/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.AttributeKey;
import io.sundr.model.AttributeSupport;
import io.sundr.model.ClassRef;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.Renderable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AnnotationRef
extends AttributeSupport
implements Renderable {
    private final ClassRef classRef;
    private final Map<String, Object> parameters;

    public AnnotationRef(ClassRef classRef, Map<String, Object> parameters, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.classRef = classRef;
        this.parameters = parameters;
    }

    public ClassRef getClassRef() {
        return this.classRef;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> result = new HashSet<ClassRef>();
        result.add(this.classRef);
        for (Object o : this.parameters.values()) {
            if (o instanceof ClassRef) {
                result.add((ClassRef)o);
                continue;
            }
            if (o instanceof AnnotationRef) {
                result.addAll(((AnnotationRef)o).getReferences());
                continue;
            }
            if (!(o instanceof Collection)) continue;
            for (Object i : (Collection)o) {
                if (i instanceof ClassRef) {
                    result.addAll(((ClassRef)i).getReferences());
                    continue;
                }
                if (!(i instanceof AnnotationRef)) continue;
                result.addAll(((AnnotationRef)i).getReferences());
            }
        }
        return result;
    }

    private static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object[] array = new Object[length];
            for (int i = 0; i < length; ++i) {
                array[i] = Array.get(value, i);
            }
            return "{" + Arrays.stream(array).map(AnnotationRef::toString).collect(Collectors.joining(",")) + "}";
        }
        if (value instanceof Collection) {
            return "{" + String.valueOf(((Collection)value).stream().map(AnnotationRef::toString).collect(Collectors.joining(","))) + "}";
        }
        if (value instanceof PrimitiveRef || value instanceof Number || value instanceof Boolean || value.getClass().isPrimitive()) {
            return String.valueOf(value);
        }
        if (value instanceof ClassRef) {
            return ((ClassRef)value).getFullyQualifiedName() + ".class";
        }
        if (value instanceof Class) {
            return ((Class)value).getSimpleName() + ".class";
        }
        if (value instanceof AnnotationRef) {
            return value.toString();
        }
        return "\"" + value.toString().replaceAll("^" + Pattern.quote("\""), "").replaceAll(Pattern.quote("\"") + "$", "") + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationRef that = (AnnotationRef)o;
        return this.classRef.equals(that.classRef);
    }

    public int hashCode() {
        return this.classRef.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(this.classRef.toString());
        if (this.parameters != null && this.parameters.size() > 0) {
            sb.append("(");
            boolean first = true;
            if (this.parameters.size() == 1 && this.parameters.containsKey("value")) {
                Object value = this.parameters.get("value");
                sb.append(AnnotationRef.toString(value));
            } else {
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    Object value = entry.getValue();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" ").append(",");
                    }
                    sb.append(entry.getKey()).append(" ").append("=").append(" ").append(AnnotationRef.toString(value));
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

