/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Renderable;
import io.sundr.model.TypeRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Construct
implements ExpressionOrStatement {
    private final ClassRef type;
    private final List<TypeRef> parameters;
    private final List<Expression> arguments;

    public Construct(ClassRef type, List<TypeRef> parameters, List<Expression> arguments) {
        this.type = type;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public Construct(ClassRef type, List<Expression> arguments) {
        this(type, Collections.emptyList(), arguments);
    }

    public Construct(ClassRef type, Expression ... arguments) {
        this(type, Collections.emptyList(), Arrays.asList(arguments));
    }

    public Construct(Class type, List<TypeRef> parameters, List<Expression> arguments) {
        this(ClassRef.forName(type.getName()), parameters, arguments);
    }

    public Construct(Class type, List<Expression> arguments) {
        this(ClassRef.forName(type.getName()), Collections.emptyList(), arguments);
    }

    public Construct(Class type, Expression ... arguments) {
        this(ClassRef.forName(type.getName()), Collections.emptyList(), Arrays.asList(arguments));
    }

    public ClassRef getType() {
        return this.type;
    }

    public List<TypeRef> getParameters() {
        return this.parameters;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        refs.addAll(this.type.getReferences());
        for (TypeRef param : this.parameters) {
            if (!(param instanceof ClassRef)) continue;
            refs.addAll(((ClassRef)param).getReferences());
        }
        for (Expression arg : this.arguments) {
            refs.addAll(arg.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(this.type.getFullyQualifiedName());
        if (!this.parameters.isEmpty()) {
            sb.append(this.parameters.stream().map(Renderable::render).collect(Collectors.joining(", ", "<", ">")));
        }
        sb.append(this.arguments.stream().map(Expression::renderExpression).collect(Collectors.joining(", ", "(", ")")));
        return sb.toString();
    }
}

