/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Declare;
import io.sundr.model.Expression;
import io.sundr.model.Property;
import io.sundr.model.Statement;
import java.util.HashSet;
import java.util.Set;

public class Foreach
implements Statement {
    private final Declare declare;
    private final Expression expression;
    private final Statement body;

    public Foreach(Declare declare, Expression expression, Statement body) {
        this.declare = declare;
        this.expression = expression;
        this.body = body;
    }

    public Foreach(Property declarationProperty, Expression expression, Statement body) {
        this(new Declare(declarationProperty), expression, body);
    }

    public Foreach(Property declarationProperty, Property expressionProperty, Statement body) {
        this(new Declare(declarationProperty), (Expression)expressionProperty, body);
    }

    public Declare getDeclare() {
        return this.declare;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Statement getBody() {
        return this.body;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.declare != null) {
            refs.addAll(this.declare.getReferences());
        }
        if (this.expression != null) {
            refs.addAll(this.expression.getReferences());
        }
        if (this.body != null) {
            refs.addAll(this.body.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("for").append(" ").append("(");
        sb.append(this.declare.render().replaceAll(";$", ""));
        sb.append(" : ");
        sb.append(this.expression.renderExpression());
        sb.append(")");
        sb.append(" ").append("{").append("\n");
        sb.append(this.tab(this.body.renderStatement()));
        sb.append("}").append("\n");
        return sb.toString();
    }
}

