/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Renderable;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import io.sundr.model.WithScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MethodCall
extends WithScope
implements ExpressionOrStatement {
    private final String name;
    private final List<TypeRef> parameters;
    private List<Expression> arguments;

    public MethodCall(String name, Expression scope, List<TypeRef> parameters, List<Expression> arguments) {
        super(scope);
        this.name = name;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public MethodCall(String name, Expression scope, Expression ... arguments) {
        this(name, scope, new ArrayList<TypeRef>(), Arrays.asList(arguments));
    }

    public MethodCall(String name, Expression scope, List<Expression> arguments) {
        this(name, scope, new ArrayList<TypeRef>(), arguments);
    }

    public MethodCall(String name, Class scope, Expression ... arguments) {
        this(name, (Expression)ClassRef.forClass(scope), arguments);
    }

    public MethodCall(String name, Object scope, Expression ... arguments) {
        this(name, (Expression)ValueRef.from(scope, new Object[0]), arguments);
    }

    public String getName() {
        return this.name;
    }

    public List<TypeRef> getParameters() {
        return this.parameters;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.getScope() != null) {
            refs.addAll(this.getScope().getReferences());
        }
        for (TypeRef param : this.parameters) {
            if (!(param instanceof ClassRef)) continue;
            refs.addAll(((ClassRef)param).getReferences());
        }
        for (Expression arg : this.arguments) {
            refs.addAll(arg.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        if (this.getScope() != null) {
            sb.append(this.getScope().renderExpression().replaceAll(Pattern.quote(".class") + "$", "")).append(".");
            if (!this.parameters.isEmpty()) {
                sb.append("<");
                sb.append(this.parameters.stream().map(Renderable::render).collect(Collectors.joining(", ")));
                sb.append(">");
            }
        }
        sb.append(this.name).append("(");
        if (!this.arguments.isEmpty()) {
            sb.append(this.arguments.stream().map(Expression::renderExpression).collect(Collectors.joining(", ")));
        }
        sb.append(")");
        return sb.toString();
    }
}

