/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors;

import io.sundr.builder.Visitor;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.utils.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ApplyTypeParamMappingToTypeArguments
implements Visitor<ClassRefFluent<?>> {
    private static final AttributeKey<TypeParamRef> ALREADY_REPLACED_KEY = new AttributeKey(ApplyTypeParamMappingToTypeArguments.class.getName() + ".ALREADY_REPLACED", Boolean.TYPE);
    private final Map<String, TypeRef> mappings;

    public ApplyTypeParamMappingToTypeArguments(String name, TypeRef typeRef) {
        this(Maps.create((Object)name, (Object)typeRef));
    }

    public ApplyTypeParamMappingToTypeArguments(Map<String, TypeRef> mappings) {
        this.mappings = ApplyTypeParamMappingToTypeArguments.markTypeParamRefs(mappings);
    }

    public void visit(ClassRefFluent<?> classRef) {
        if (classRef.hasAttributes() && classRef.getAttributes().remove(ALREADY_REPLACED_KEY) != null) {
            return;
        }
        ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
        Iterator iterator = classRef.buildArguments().iterator();
        while (iterator.hasNext()) {
            TypeParamRef typeParamRef;
            TypeRef mapping;
            TypeRef arg;
            TypeRef mappedRef = arg = (TypeRef)iterator.next();
            if (arg instanceof TypeParamRef && (mapping = this.mappings.get((typeParamRef = (TypeParamRef)arg).getName())) != null) {
                mappedRef = mapping;
            }
            arguments.add(mappedRef);
        }
        classRef.withArguments(arguments);
    }

    private static Map<String, TypeRef> markTypeParamRefs(Map<String, TypeRef> mappings) {
        HashMap<String, TypeRef> result = new HashMap<String, TypeRef>(mappings.size());
        mappings.forEach((key, target) -> {
            if (target instanceof ClassRef) {
                target = ((ClassRefBuilder)new ClassRefBuilder((ClassRef)target).addToAttributes(ALREADY_REPLACED_KEY, (Object)true)).build();
            }
            result.put((String)key, (TypeRef)target);
        });
        return result;
    }
}

