/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.model.ClassRef;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.model.functions.ClassAssignable;
import io.sundr.model.functions.PrimitiveAssignable;
import io.sundr.model.functions.TypeAssignable;

public class Assignable {
    public static RefAssignable isAssignable(TypeRef type) {
        return new RefAssignable(type);
    }

    public static DefAssignable isAssignable(TypeDef type) {
        return new DefAssignable(type);
    }

    public static class DefAssignable {
        public final TypeDef type;

        public DefAssignable(TypeDef type) {
            this.type = type;
        }

        public boolean from(TypeDef other) {
            return new TypeAssignable(this.type).from(other);
        }
    }

    public static class RefAssignable {
        public final TypeRef type;

        public RefAssignable(TypeRef type) {
            this.type = type;
        }

        public boolean from(TypeRef other) {
            if (this.type instanceof ClassRef) {
                return new ClassAssignable((ClassRef)this.type).from(other);
            }
            if (this.type instanceof PrimitiveRef) {
                return new PrimitiveAssignable((PrimitiveRef)this.type).from(other);
            }
            if (this.type instanceof TypeParamRef) {
                return this.type.equals(other);
            }
            return false;
        }
    }
}

