/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.builder.Visitor;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.RichTypeDef;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.model.functions.GetDefinition;
import io.sundr.model.utils.Types;
import io.sundr.model.visitors.ApplyTypeParamMappingToMethod;
import io.sundr.model.visitors.ApplyTypeParamMappingToProperty;
import io.sundr.model.visitors.ApplyTypeParamMappingToTypeArguments;
import io.sundr.utils.Predicates;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeArguments {
    public static final AttributeKey<TypeParamRef> ORIGINAL_TYPE_PARAMETER = new AttributeKey("ORIGINAL_TYPE_PARAMETER", String.class);
    private static final Predicate<ClassRef> INTERNAL_JDK = c -> c.equals((Object)Types.OBJECT_REF) || c.getFullyQualifiedName().startsWith("jdk.internal");

    public static RichTypeDef apply(ClassRef classRef) {
        TypeDef definition = TypeArguments.applyGenericArguments(classRef);
        return TypeArguments.apply(definition);
    }

    public static RichTypeDef apply(TypeDef definition) {
        List<ClassRef> classRefs = definition.getExtendsList().stream().flatMap(s -> Stream.concat(Stream.of(s), TypeArguments.applyGenericArguments(s).getExtendsList().stream())).collect(Collectors.toList());
        List typeDefs = classRefs.stream().map(TypeArguments::applyGenericArguments).collect(Collectors.toList());
        List<Property> allProperties = TypeArguments.applyToProperties(definition);
        List<Method> allMethods = TypeArguments.applyToMethods(definition);
        List<Method> allConstructors = TypeArguments.applyToConstructors(definition);
        return new RichTypeDef(definition.getKind(), definition.getPackageName(), definition.getName(), definition.getComments(), definition.getAnnotations(), classRefs, definition.getImplementsList(), definition.getParameters(), definition.getProperties(), allProperties, definition.getConstructors(), allConstructors, definition.getMethods(), allMethods, definition.getOuterTypeName(), definition.getInnerTypes().stream().map(i -> TypeArguments.apply(i)).collect(Collectors.toList()), definition.getModifiers(), definition.getAttributes());
    }

    public static Map<String, TypeRef> getGenericArgumentsMappings(ClassRef ref) {
        return TypeArguments.getGenericArgumentsMappings(ref, GetDefinition.of(ref));
    }

    public static Map<String, TypeRef> getGenericArgumentsMappings(ClassRef ref, TypeDef definition) {
        List arguments = ref.getArguments();
        if (arguments.isEmpty()) {
            return Collections.emptyMap();
        }
        List parameters = definition.getParameters();
        if (parameters.size() != arguments.size()) {
            throw new IllegalStateException("Incompatible reference " + ref + " to " + definition);
        }
        HashMap<String, TypeRef> mappings = new HashMap<String, TypeRef>();
        for (int i = 0; i < arguments.size(); ++i) {
            String name = ((TypeParamDef)parameters.get(i)).getName();
            TypeRef typeRef = (TypeRef)arguments.get(i);
            mappings.put(name, typeRef);
        }
        return mappings;
    }

    private static TypeDef applyGenericArguments(ClassRef ref) {
        TypeDef definition = GetDefinition.of(ref);
        Map<String, TypeRef> mappings = TypeArguments.getGenericArgumentsMappings(ref, definition);
        if (mappings.isEmpty()) {
            return definition;
        }
        return ((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(definition).accept(new Visitor[]{new ApplyTypeParamMappingToTypeArguments(mappings)})).accept(new Visitor[]{new ApplyTypeParamMappingToProperty(mappings, ORIGINAL_TYPE_PARAMETER), new ApplyTypeParamMappingToMethod(mappings, ORIGINAL_TYPE_PARAMETER)})).build();
    }

    private static List<Property> applyToProperties(TypeDef definition) {
        return Stream.concat(definition.getProperties().stream(), definition.getExtendsList().stream().filter(INTERNAL_JDK.negate()).flatMap(e -> TypeArguments.applyToProperties(TypeArguments.applyGenericArguments(e)).stream())).filter(Predicates.distinct(Property::withErasure)).collect(Collectors.toList());
    }

    private static List<Method> applyToMethods(TypeDef definition) {
        return Stream.concat(definition.getMethods().stream(), definition.getExtendsList().stream().filter(INTERNAL_JDK.negate()).flatMap(e -> TypeArguments.applyToMethods(TypeArguments.applyGenericArguments(e)).stream())).filter(Predicates.distinct(m -> m.withErasure().getSignature())).collect(Collectors.toList());
    }

    private static List<Method> applyToConstructors(TypeDef definition) {
        return Stream.concat(definition.getConstructors().stream(), definition.getExtendsList().stream().filter(INTERNAL_JDK.negate()).flatMap(e -> TypeArguments.applyToConstructors(TypeArguments.applyGenericArguments(e)).stream())).collect(Collectors.toList());
    }

    private static Map<AttributeKey, Object> mergeStringArrays(AttributeKey<String[]> key, Map<AttributeKey, Object> subtotal, Map<AttributeKey, Object> element) {
        HashMap<AttributeKey, Object> result = new HashMap<AttributeKey, Object>();
        result.put(key, Stream.concat(Arrays.stream((String[])subtotal.getOrDefault(key, new String[0])), Arrays.stream((String[])element.getOrDefault(key, new String[0]))).toArray(String[]::new));
        return result;
    }
}

