/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors;

import io.sundr.builder.Visitor;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PropertyFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.utils.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ApplyTypeParamMappingToProperty
implements Visitor<PropertyFluent<?>> {
    private final Map<String, TypeRef> mappings;
    private final Optional<AttributeKey<TypeParamRef>> attributeKey;

    public ApplyTypeParamMappingToProperty(String name, TypeRef typeRef) {
        this(Maps.create((Object)name, (Object)typeRef));
    }

    public ApplyTypeParamMappingToProperty(Map<String, TypeRef> mappings) {
        this(mappings, Optional.empty());
    }

    public ApplyTypeParamMappingToProperty(Map<String, TypeRef> mappings, AttributeKey<TypeParamRef> attributeKey) {
        this(mappings, Optional.ofNullable(attributeKey));
    }

    public ApplyTypeParamMappingToProperty(Map<String, TypeRef> mappings, Optional<AttributeKey<TypeParamRef>> attributeKey) {
        this.mappings = mappings;
        this.attributeKey = attributeKey;
    }

    public void visit(PropertyFluent<?> property) {
        ClassRef classRef;
        TypeRef typeRef = property.buildTypeRef();
        if (typeRef instanceof TypeParamRef) {
            TypeParamRef typeParamRef = (TypeParamRef)typeRef;
            String key = typeParamRef.getName();
            TypeRef paramRef = this.mappings.get(key);
            if (paramRef != null) {
                property.withTypeRef(paramRef);
                this.attributeKey.ifPresent(k -> property.addToAttributes(k, (Object)typeParamRef));
            }
        } else if (typeRef instanceof ClassRef && (classRef = (ClassRef)typeRef).getArguments().stream().anyMatch(a -> a instanceof TypeParamRef)) {
            List mappedArguments = classRef.getArguments().stream().map(a -> a instanceof TypeParamRef ? this.mappings.getOrDefault(((TypeParamRef)a).getName(), (TypeRef)a) : a).collect(Collectors.toList());
            property.withTypeRef((TypeRef)((ClassRefBuilder)new ClassRefBuilder(classRef).withArguments(mappedArguments)).build());
            this.attributeKey.ifPresent(k -> property.addToAttributes(k, (Object)classRef));
        }
    }
}

