/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.visitors.context.resolver;

import io.sundr.builder.Visitable;
import io.sundr.builder.Visitor;
import io.sundr.model.BlockFluent;
import io.sundr.model.Declare;
import io.sundr.model.Expression;
import io.sundr.model.Statement;
import io.sundr.model.utils.Resolvers;
import io.sundr.model.visitors.context.resolver.MethodArgumentsResolver;
import io.sundr.model.visitors.context.resolver.MethodCallArgumentsResolver;
import io.sundr.model.visitors.context.resolver.ScopeResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalVariableResolver
implements Visitor<BlockFluent<?>> {
    private final Map<String, Expression> resolved;

    public LocalVariableResolver(Map<String, Expression> resolved) {
        this.resolved = resolved;
    }

    public void visit(BlockFluent<?> fluent) {
        List statements = fluent.buildStatements();
        HashMap<String, Expression> resolutionWithLocalVariablesMap = new HashMap<String, Expression>(this.resolved);
        for (Statement statement : statements) {
            if (!(statement instanceof Declare)) continue;
            Declare declare = (Declare)statement;
            resolutionWithLocalVariablesMap.putAll(Resolvers.createResolutionMap(declare.getProperties()));
        }
        if (fluent instanceof Visitable) {
            Visitable visitable = (Visitable)fluent;
            visitable.accept(new Visitor[]{new MethodArgumentsResolver(resolutionWithLocalVariablesMap)});
            visitable.accept(new Visitor[]{new ScopeResolver(resolutionWithLocalVariablesMap)});
            visitable.accept(new Visitor[]{new MethodCallArgumentsResolver(resolutionWithLocalVariablesMap)});
        }
    }
}

