/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AnnotationRefFluent;
import io.sundr.model.Assign;
import io.sundr.model.AssignBuilder;
import io.sundr.model.AssignFluent;
import io.sundr.model.BinaryExpression;
import io.sundr.model.BinaryExpressionBuilder;
import io.sundr.model.BinaryExpressionFluent;
import io.sundr.model.BitwiseAnd;
import io.sundr.model.BitwiseAndBuilder;
import io.sundr.model.BitwiseAndFluent;
import io.sundr.model.BitwiseOr;
import io.sundr.model.BitwiseOrBuilder;
import io.sundr.model.BitwiseOrFluent;
import io.sundr.model.Cast;
import io.sundr.model.CastBuilder;
import io.sundr.model.CastFluent;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.Construct;
import io.sundr.model.ConstructBuilder;
import io.sundr.model.ConstructFluent;
import io.sundr.model.ContextRef;
import io.sundr.model.ContextRefBuilder;
import io.sundr.model.ContextRefFluent;
import io.sundr.model.Declare;
import io.sundr.model.DeclareBuilder;
import io.sundr.model.DeclareFluent;
import io.sundr.model.Divide;
import io.sundr.model.DivideBuilder;
import io.sundr.model.DivideFluent;
import io.sundr.model.DotClass;
import io.sundr.model.DotClassBuilder;
import io.sundr.model.DotClassFluent;
import io.sundr.model.Empty;
import io.sundr.model.EmptyBuilder;
import io.sundr.model.EmptyFluent;
import io.sundr.model.Enclosed;
import io.sundr.model.EnclosedBuilder;
import io.sundr.model.EnclosedFluent;
import io.sundr.model.Equals;
import io.sundr.model.EqualsBuilder;
import io.sundr.model.EqualsFluent;
import io.sundr.model.Expression;
import io.sundr.model.GreaterThan;
import io.sundr.model.GreaterThanBuilder;
import io.sundr.model.GreaterThanFluent;
import io.sundr.model.GreaterThanOrEqual;
import io.sundr.model.GreaterThanOrEqualBuilder;
import io.sundr.model.GreaterThanOrEqualFluent;
import io.sundr.model.Index;
import io.sundr.model.IndexBuilder;
import io.sundr.model.IndexFluent;
import io.sundr.model.InstanceOf;
import io.sundr.model.InstanceOfBuilder;
import io.sundr.model.InstanceOfFluent;
import io.sundr.model.Inverse;
import io.sundr.model.InverseBuilder;
import io.sundr.model.InverseFluent;
import io.sundr.model.Lambda;
import io.sundr.model.LambdaBuilder;
import io.sundr.model.LambdaFluent;
import io.sundr.model.LeftShift;
import io.sundr.model.LeftShiftBuilder;
import io.sundr.model.LeftShiftFluent;
import io.sundr.model.LessThan;
import io.sundr.model.LessThanBuilder;
import io.sundr.model.LessThanFluent;
import io.sundr.model.LessThanOrEqual;
import io.sundr.model.LessThanOrEqualBuilder;
import io.sundr.model.LessThanOrEqualFluent;
import io.sundr.model.LogicalAnd;
import io.sundr.model.LogicalAndBuilder;
import io.sundr.model.LogicalAndFluent;
import io.sundr.model.LogicalOr;
import io.sundr.model.LogicalOrBuilder;
import io.sundr.model.LogicalOrFluent;
import io.sundr.model.MethodCall;
import io.sundr.model.MethodCallBuilder;
import io.sundr.model.MethodCallFluent;
import io.sundr.model.Minus;
import io.sundr.model.MinusBuilder;
import io.sundr.model.MinusFluent;
import io.sundr.model.ModifierSupportFluent;
import io.sundr.model.Modulo;
import io.sundr.model.ModuloBuilder;
import io.sundr.model.ModuloFluent;
import io.sundr.model.Multiply;
import io.sundr.model.MultiplyBuilder;
import io.sundr.model.MultiplyFluent;
import io.sundr.model.Negative;
import io.sundr.model.NegativeBuilder;
import io.sundr.model.NegativeFluent;
import io.sundr.model.NewArray;
import io.sundr.model.NewArrayBuilder;
import io.sundr.model.NewArrayFluent;
import io.sundr.model.Not;
import io.sundr.model.NotBuilder;
import io.sundr.model.NotEquals;
import io.sundr.model.NotEqualsBuilder;
import io.sundr.model.NotEqualsFluent;
import io.sundr.model.NotFluent;
import io.sundr.model.Plus;
import io.sundr.model.PlusBuilder;
import io.sundr.model.PlusFluent;
import io.sundr.model.Positive;
import io.sundr.model.PositiveBuilder;
import io.sundr.model.PositiveFluent;
import io.sundr.model.PostDecrement;
import io.sundr.model.PostDecrementBuilder;
import io.sundr.model.PostDecrementFluent;
import io.sundr.model.PostIncrement;
import io.sundr.model.PostIncrementBuilder;
import io.sundr.model.PostIncrementFluent;
import io.sundr.model.PreDecrement;
import io.sundr.model.PreDecrementBuilder;
import io.sundr.model.PreDecrementFluent;
import io.sundr.model.PreIncrement;
import io.sundr.model.PreIncrementBuilder;
import io.sundr.model.PreIncrementFluent;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluent;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.PropertyRef;
import io.sundr.model.PropertyRefBuilder;
import io.sundr.model.PropertyRefFluent;
import io.sundr.model.RightShift;
import io.sundr.model.RightShiftBuilder;
import io.sundr.model.RightShiftFluent;
import io.sundr.model.RightUnsignedShift;
import io.sundr.model.RightUnsignedShiftBuilder;
import io.sundr.model.RightUnsignedShiftFluent;
import io.sundr.model.Super;
import io.sundr.model.SuperBuilder;
import io.sundr.model.SuperFluent;
import io.sundr.model.Ternary;
import io.sundr.model.TernaryBuilder;
import io.sundr.model.TernaryFluent;
import io.sundr.model.This;
import io.sundr.model.ThisBuilder;
import io.sundr.model.ThisFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluent;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import io.sundr.model.ValueRefBuilder;
import io.sundr.model.ValueRefFluent;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluent;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.WildcardRefFluent;
import io.sundr.model.Xor;
import io.sundr.model.XorBuilder;
import io.sundr.model.XorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PropertyFluent<A extends PropertyFluent<A>>
extends ModifierSupportFluent<A> {
    private ArrayList<AnnotationRefBuilder> annotations = new ArrayList();
    private List<String> comments = new ArrayList<String>();
    private boolean enumConstant;
    private Optional<VisitableBuilder<? extends Expression, ?>> initialValue = Optional.empty();
    private String name;
    private boolean synthetic;
    private VisitableBuilder<? extends TypeRef, ?> typeRef;

    public PropertyFluent() {
    }

    public PropertyFluent(Property instance) {
        this.copyInstance(instance);
    }

    public A addAllToAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToComments(Collection<String> items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNested(-1, null);
    }

    public AnnotationsNested<A> addNewAnnotationLike(AnnotationRef item) {
        return new AnnotationsNested(-1, item);
    }

    public A addToAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToComments(String ... items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A addToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(index, item);
        return (A)((Object)this);
    }

    public AnnotationRef buildAnnotation(int index) {
        return this.annotations.get(index).build();
    }

    public List<AnnotationRef> buildAnnotations() {
        return this.annotations != null ? PropertyFluent.build(this.annotations) : null;
    }

    public AnnotationRef buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    public Optional<Expression> buildInitialValue() {
        return this.initialValue != null ? this.initialValue.map(v -> (Expression)v.build()) : Optional.empty();
    }

    public AnnotationRef buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    public AnnotationRef buildMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TypeRef buildTypeRef() {
        return this.typeRef != null ? (TypeRef)this.typeRef.build() : null;
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "ClassRef": {
                return new ClassRefBuilder((ClassRef)item);
            }
            case "PrimitiveRef": {
                return new PrimitiveRefBuilder((PrimitiveRef)item);
            }
            case "VoidRef": {
                return new VoidRefBuilder((VoidRef)item);
            }
            case "TypeParamRef": {
                return new TypeParamRefBuilder((TypeParamRef)item);
            }
            case "WildcardRef": {
                return new WildcardRefBuilder((WildcardRef)item);
            }
            case "Multiply": {
                return new MultiplyBuilder((Multiply)item);
            }
            case "NewArray": {
                return new NewArrayBuilder((NewArray)item);
            }
            case "InstanceOf": {
                return new InstanceOfBuilder((InstanceOf)item);
            }
            case "MethodCall": {
                return new MethodCallBuilder((MethodCall)item);
            }
            case "Inverse": {
                return new InverseBuilder((Inverse)item);
            }
            case "Index": {
                return new IndexBuilder((Index)item);
            }
            case "GreaterThanOrEqual": {
                return new GreaterThanOrEqualBuilder((GreaterThanOrEqual)item);
            }
            case "BitwiseAnd": {
                return new BitwiseAndBuilder((BitwiseAnd)item);
            }
            case "Minus": {
                return new MinusBuilder((Minus)item);
            }
            case "LogicalOr": {
                return new LogicalOrBuilder((LogicalOr)item);
            }
            case "NotEquals": {
                return new NotEqualsBuilder((NotEquals)item);
            }
            case "Divide": {
                return new DivideBuilder((Divide)item);
            }
            case "LessThan": {
                return new LessThanBuilder((LessThan)item);
            }
            case "BitwiseOr": {
                return new BitwiseOrBuilder((BitwiseOr)item);
            }
            case "PropertyRef": {
                return new PropertyRefBuilder((PropertyRef)item);
            }
            case "RightShift": {
                return new RightShiftBuilder((RightShift)item);
            }
            case "Super": {
                return new SuperBuilder((Super)item);
            }
            case "GreaterThan": {
                return new GreaterThanBuilder((GreaterThan)item);
            }
            case "Declare": {
                return new DeclareBuilder((Declare)item);
            }
            case "Cast": {
                return new CastBuilder((Cast)item);
            }
            case "Modulo": {
                return new ModuloBuilder((Modulo)item);
            }
            case "DotClass": {
                return new DotClassBuilder((DotClass)item);
            }
            case "ValueRef": {
                return new ValueRefBuilder((ValueRef)item);
            }
            case "LeftShift": {
                return new LeftShiftBuilder((LeftShift)item);
            }
            case "Empty": {
                return new EmptyBuilder((Empty)item);
            }
            case "Ternary": {
                return new TernaryBuilder((Ternary)item);
            }
            case "BinaryExpression": {
                return new BinaryExpressionBuilder((BinaryExpression)item);
            }
            case "Equals": {
                return new EqualsBuilder((Equals)item);
            }
            case "Enclosed": {
                return new EnclosedBuilder((Enclosed)item);
            }
            case "PreDecrement": {
                return new PreDecrementBuilder((PreDecrement)item);
            }
            case "PostDecrement": {
                return new PostDecrementBuilder((PostDecrement)item);
            }
            case "Lambda": {
                return new LambdaBuilder((Lambda)item);
            }
            case "Not": {
                return new NotBuilder((Not)item);
            }
            case "Assign": {
                return new AssignBuilder((Assign)item);
            }
            case "This": {
                return new ThisBuilder((This)item);
            }
            case "Negative": {
                return new NegativeBuilder((Negative)item);
            }
            case "LogicalAnd": {
                return new LogicalAndBuilder((LogicalAnd)item);
            }
            case "PostIncrement": {
                return new PostIncrementBuilder((PostIncrement)item);
            }
            case "RightUnsignedShift": {
                return new RightUnsignedShiftBuilder((RightUnsignedShift)item);
            }
            case "Plus": {
                return new PlusBuilder((Plus)item);
            }
            case "Construct": {
                return new ConstructBuilder((Construct)item);
            }
            case "Xor": {
                return new XorBuilder((Xor)item);
            }
            case "PreIncrement": {
                return new PreIncrementBuilder((PreIncrement)item);
            }
            case "Property": {
                return new PropertyBuilder((Property)item);
            }
            case "LessThanOrEqual": {
                return new LessThanOrEqualBuilder((LessThanOrEqual)item);
            }
            case "ContextRef": {
                return new ContextRefBuilder((ContextRef)item);
            }
            case "Positive": {
                return new PositiveBuilder((Positive)item);
            }
        }
        return PropertyFluent.builderOf((Object)item);
    }

    protected void copyInstance(Property instance) {
        if (instance != null) {
            this.withModifiers(instance.getModifiers());
            this.withAttributes(instance.getAttributes());
            this.withComments(instance.getComments());
            this.withAnnotations(instance.getAnnotations());
            this.withTypeRef(instance.getTypeRef());
            this.withName(instance.getName());
            this.withInitialValue(instance.getInitialValue());
            this.withEnumConstant(instance.isEnumConstant());
            this.withSynthetic(instance.isSynthetic());
        }
    }

    public AnnotationsNested<A> editAnnotation(int index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "annotations"));
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "annotations"));
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    public AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "annotations"));
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "annotations"));
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertyFluent that = (PropertyFluent)((Object)o);
        if (!Objects.equals(this.comments, that.comments)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.typeRef, that.typeRef)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.initialValue, that.initialValue)) {
            return false;
        }
        if (this.enumConstant != that.enumConstant) {
            return false;
        }
        return this.synthetic == that.synthetic;
    }

    public String getComment(int index) {
        return this.comments.get(index);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getFirstComment() {
        return this.comments.get(0);
    }

    public String getLastComment() {
        return this.comments.get(this.comments.size() - 1);
    }

    public String getMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public boolean hasEnumConstant() {
        return true;
    }

    public boolean hasInitialValue() {
        return this.initialValue != null && this.initialValue.isPresent();
    }

    public boolean hasMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasSynthetic() {
        return true;
    }

    public boolean hasTypeRef() {
        return this.typeRef != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.comments, this.annotations, this.typeRef, this.name, this.initialValue, this.enumConstant, this.synthetic);
    }

    public boolean isEnumConstant() {
        return this.enumConstant;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public A removeAllFromAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComments(Collection<String> items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromComments(String ... items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAnnotations(Predicate<AnnotationRefBuilder> predicate) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        Iterator<AnnotationRefBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AnnotationsNested<A> setNewAnnotationLike(int index, AnnotationRef item) {
        return new AnnotationsNested(index, item);
    }

    public A setToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.set(index, item);
        return (A)((Object)this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append("comments:");
            sb.append(this.comments);
            sb.append(",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.typeRef != null) {
            sb.append("typeRef:");
            sb.append(this.typeRef);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.initialValue != null) {
            sb.append("initialValue:");
            sb.append(this.initialValue);
            sb.append(",");
        }
        sb.append("enumConstant:");
        sb.append(this.enumConstant);
        sb.append(",");
        sb.append("synthetic:");
        sb.append(this.synthetic);
        sb.append("}");
        return sb.toString();
    }

    public A withAnnotations(List<AnnotationRef> annotations) {
        if (this.annotations != null) {
            this._visitables.get((Object)"annotations").clear();
        }
        if (annotations != null) {
            this.annotations = new ArrayList();
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        } else {
            this.annotations = null;
        }
        return (A)((Object)this);
    }

    public A withAnnotations(AnnotationRef ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
            this._visitables.remove((Object)"annotations");
        }
        if (annotations != null) {
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public A withComments(List<String> comments) {
        if (comments != null) {
            this.comments = new ArrayList<String>();
            for (String item : comments) {
                this.addToComments(item);
            }
        } else {
            this.comments = null;
        }
        return (A)((Object)this);
    }

    public A withComments(String ... comments) {
        if (this.comments != null) {
            this.comments.clear();
            this._visitables.remove((Object)"comments");
        }
        if (comments != null) {
            for (String item : comments) {
                this.addToComments(item);
            }
        }
        return (A)((Object)this);
    }

    public A withEnumConstant() {
        return this.withEnumConstant(true);
    }

    public A withEnumConstant(boolean enumConstant) {
        this.enumConstant = enumConstant;
        return (A)((Object)this);
    }

    public A withInitialValue(Optional<Expression> initialValue) {
        if (initialValue == null || !initialValue.isPresent()) {
            this.initialValue = Optional.empty();
        } else {
            VisitableBuilder b = PropertyFluent.builder(initialValue.get());
            this._visitables.get((Object)"initialValue").add(b);
            this.initialValue = Optional.of(b);
        }
        return (A)((Object)this);
    }

    public A withInitialValue(Expression initialValue) {
        if (initialValue == null) {
            this.initialValue = Optional.empty();
        } else {
            VisitableBuilder b = PropertyFluent.builder(initialValue);
            this._visitables.get((Object)"initialValue").add(b);
            this.initialValue = Optional.of(b);
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public AssignInitialValueNested<A> withNewAssignInitialValue() {
        return new AssignInitialValueNested(null);
    }

    public AssignInitialValueNested<A> withNewAssignInitialValueLike(Assign item) {
        return new AssignInitialValueNested(item);
    }

    public BinaryExpressionInitialValueNested<A> withNewBinaryExpressionInitialValue() {
        return new BinaryExpressionInitialValueNested(null);
    }

    public BinaryExpressionInitialValueNested<A> withNewBinaryExpressionInitialValueLike(BinaryExpression item) {
        return new BinaryExpressionInitialValueNested(item);
    }

    public BitwiseAndInitialValueNested<A> withNewBitwiseAndInitialValue() {
        return new BitwiseAndInitialValueNested(null);
    }

    public A withNewBitwiseAndInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new BitwiseAnd(left, right));
    }

    public BitwiseAndInitialValueNested<A> withNewBitwiseAndInitialValueLike(BitwiseAnd item) {
        return new BitwiseAndInitialValueNested(item);
    }

    public BitwiseOrInitialValueNested<A> withNewBitwiseOrInitialValue() {
        return new BitwiseOrInitialValueNested(null);
    }

    public A withNewBitwiseOrInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new BitwiseOr(left, right));
    }

    public BitwiseOrInitialValueNested<A> withNewBitwiseOrInitialValueLike(BitwiseOr item) {
        return new BitwiseOrInitialValueNested(item);
    }

    public CastInitialValueNested<A> withNewCastInitialValue() {
        return new CastInitialValueNested(null);
    }

    public CastInitialValueNested<A> withNewCastInitialValueLike(Cast item) {
        return new CastInitialValueNested(item);
    }

    public ClassRefInitialValueNested<A> withNewClassRefInitialValue() {
        return new ClassRefInitialValueNested(null);
    }

    public ClassRefInitialValueNested<A> withNewClassRefInitialValueLike(ClassRef item) {
        return new ClassRefInitialValueNested(item);
    }

    public ClassRefTypeNested<A> withNewClassRefType() {
        return new ClassRefTypeNested(null);
    }

    public ClassRefTypeNested<A> withNewClassRefTypeLike(ClassRef item) {
        return new ClassRefTypeNested(item);
    }

    public ConstructInitialValueNested<A> withNewConstructInitialValue() {
        return new ConstructInitialValueNested(null);
    }

    public ConstructInitialValueNested<A> withNewConstructInitialValueLike(Construct item) {
        return new ConstructInitialValueNested(item);
    }

    public ContextRefInitialValueNested<A> withNewContextRefInitialValue() {
        return new ContextRefInitialValueNested(null);
    }

    public A withNewContextRefInitialValue(String name) {
        return this.withInitialValue((Expression)new ContextRef(name));
    }

    public ContextRefInitialValueNested<A> withNewContextRefInitialValueLike(ContextRef item) {
        return new ContextRefInitialValueNested(item);
    }

    public DeclareInitialValueNested<A> withNewDeclareInitialValue() {
        return new DeclareInitialValueNested(null);
    }

    public A withNewDeclareInitialValue(Class type, String name) {
        return this.withInitialValue((Expression)new Declare(type, name));
    }

    public A withNewDeclareInitialValue(Class type, String name, Object value) {
        return this.withInitialValue((Expression)new Declare(type, name, value));
    }

    public DeclareInitialValueNested<A> withNewDeclareInitialValueLike(Declare item) {
        return new DeclareInitialValueNested(item);
    }

    public DivideInitialValueNested<A> withNewDivideInitialValue() {
        return new DivideInitialValueNested(null);
    }

    public A withNewDivideInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Divide(left, right));
    }

    public DivideInitialValueNested<A> withNewDivideInitialValueLike(Divide item) {
        return new DivideInitialValueNested(item);
    }

    public DotClassInitialValueNested<A> withNewDotClassInitialValue() {
        return new DotClassInitialValueNested(null);
    }

    public DotClassInitialValueNested<A> withNewDotClassInitialValueLike(DotClass item) {
        return new DotClassInitialValueNested(item);
    }

    public EmptyInitialValueNested<A> withNewEmptyInitialValue() {
        return new EmptyInitialValueNested(null);
    }

    public EmptyInitialValueNested<A> withNewEmptyInitialValueLike(Empty item) {
        return new EmptyInitialValueNested(item);
    }

    public EnclosedInitialValueNested<A> withNewEnclosedInitialValue() {
        return new EnclosedInitialValueNested(null);
    }

    public EnclosedInitialValueNested<A> withNewEnclosedInitialValueLike(Enclosed item) {
        return new EnclosedInitialValueNested(item);
    }

    public EqualsInitialValueNested<A> withNewEqualsInitialValue() {
        return new EqualsInitialValueNested(null);
    }

    public A withNewEqualsInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Equals(left, right));
    }

    public EqualsInitialValueNested<A> withNewEqualsInitialValueLike(Equals item) {
        return new EqualsInitialValueNested(item);
    }

    public GreaterThanInitialValueNested<A> withNewGreaterThanInitialValue() {
        return new GreaterThanInitialValueNested(null);
    }

    public A withNewGreaterThanInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new GreaterThan(left, right));
    }

    public GreaterThanInitialValueNested<A> withNewGreaterThanInitialValueLike(GreaterThan item) {
        return new GreaterThanInitialValueNested(item);
    }

    public GreaterThanOrEqualInitialValueNested<A> withNewGreaterThanOrEqualInitialValue() {
        return new GreaterThanOrEqualInitialValueNested(null);
    }

    public A withNewGreaterThanOrEqualInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new GreaterThanOrEqual(left, right));
    }

    public GreaterThanOrEqualInitialValueNested<A> withNewGreaterThanOrEqualInitialValueLike(GreaterThanOrEqual item) {
        return new GreaterThanOrEqualInitialValueNested(item);
    }

    public IndexInitialValueNested<A> withNewIndexInitialValue() {
        return new IndexInitialValueNested(null);
    }

    public IndexInitialValueNested<A> withNewIndexInitialValueLike(Index item) {
        return new IndexInitialValueNested(item);
    }

    public InstanceOfInitialValueNested<A> withNewInstanceOfInitialValue() {
        return new InstanceOfInitialValueNested(null);
    }

    public InstanceOfInitialValueNested<A> withNewInstanceOfInitialValueLike(InstanceOf item) {
        return new InstanceOfInitialValueNested(item);
    }

    public InverseInitialValueNested<A> withNewInverseInitialValue() {
        return new InverseInitialValueNested(null);
    }

    public InverseInitialValueNested<A> withNewInverseInitialValueLike(Inverse item) {
        return new InverseInitialValueNested(item);
    }

    public LambdaInitialValueNested<A> withNewLambdaInitialValue() {
        return new LambdaInitialValueNested(null);
    }

    public LambdaInitialValueNested<A> withNewLambdaInitialValueLike(Lambda item) {
        return new LambdaInitialValueNested(item);
    }

    public LeftShiftInitialValueNested<A> withNewLeftShiftInitialValue() {
        return new LeftShiftInitialValueNested(null);
    }

    public A withNewLeftShiftInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new LeftShift(left, right));
    }

    public LeftShiftInitialValueNested<A> withNewLeftShiftInitialValueLike(LeftShift item) {
        return new LeftShiftInitialValueNested(item);
    }

    public LessThanInitialValueNested<A> withNewLessThanInitialValue() {
        return new LessThanInitialValueNested(null);
    }

    public A withNewLessThanInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new LessThan(left, right));
    }

    public LessThanInitialValueNested<A> withNewLessThanInitialValueLike(LessThan item) {
        return new LessThanInitialValueNested(item);
    }

    public LessThanOrEqualInitialValueNested<A> withNewLessThanOrEqualInitialValue() {
        return new LessThanOrEqualInitialValueNested(null);
    }

    public A withNewLessThanOrEqualInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new LessThanOrEqual(left, right));
    }

    public LessThanOrEqualInitialValueNested<A> withNewLessThanOrEqualInitialValueLike(LessThanOrEqual item) {
        return new LessThanOrEqualInitialValueNested(item);
    }

    public LogicalAndInitialValueNested<A> withNewLogicalAndInitialValue() {
        return new LogicalAndInitialValueNested(null);
    }

    public A withNewLogicalAndInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new LogicalAnd(left, right));
    }

    public LogicalAndInitialValueNested<A> withNewLogicalAndInitialValueLike(LogicalAnd item) {
        return new LogicalAndInitialValueNested(item);
    }

    public LogicalOrInitialValueNested<A> withNewLogicalOrInitialValue() {
        return new LogicalOrInitialValueNested(null);
    }

    public A withNewLogicalOrInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new LogicalOr(left, right));
    }

    public LogicalOrInitialValueNested<A> withNewLogicalOrInitialValueLike(LogicalOr item) {
        return new LogicalOrInitialValueNested(item);
    }

    public MethodCallInitialValueNested<A> withNewMethodCallInitialValue() {
        return new MethodCallInitialValueNested(null);
    }

    public MethodCallInitialValueNested<A> withNewMethodCallInitialValueLike(MethodCall item) {
        return new MethodCallInitialValueNested(item);
    }

    public MinusInitialValueNested<A> withNewMinusInitialValue() {
        return new MinusInitialValueNested(null);
    }

    public A withNewMinusInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Minus(left, right));
    }

    public MinusInitialValueNested<A> withNewMinusInitialValueLike(Minus item) {
        return new MinusInitialValueNested(item);
    }

    public ModuloInitialValueNested<A> withNewModuloInitialValue() {
        return new ModuloInitialValueNested(null);
    }

    public A withNewModuloInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Modulo(left, right));
    }

    public ModuloInitialValueNested<A> withNewModuloInitialValueLike(Modulo item) {
        return new ModuloInitialValueNested(item);
    }

    public MultiplyInitialValueNested<A> withNewMultiplyInitialValue() {
        return new MultiplyInitialValueNested(null);
    }

    public A withNewMultiplyInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Multiply(left, right));
    }

    public MultiplyInitialValueNested<A> withNewMultiplyInitialValueLike(Multiply item) {
        return new MultiplyInitialValueNested(item);
    }

    public NegativeInitialValueNested<A> withNewNegativeInitialValue() {
        return new NegativeInitialValueNested(null);
    }

    public NegativeInitialValueNested<A> withNewNegativeInitialValueLike(Negative item) {
        return new NegativeInitialValueNested(item);
    }

    public NewArrayInitialValueNested<A> withNewNewArrayInitialValue() {
        return new NewArrayInitialValueNested(null);
    }

    public A withNewNewArrayInitialValue(Class type, Integer[] sizes) {
        return this.withInitialValue((Expression)new NewArray(type, sizes));
    }

    public NewArrayInitialValueNested<A> withNewNewArrayInitialValueLike(NewArray item) {
        return new NewArrayInitialValueNested(item);
    }

    public NotEqualsInitialValueNested<A> withNewNotEqualsInitialValue() {
        return new NotEqualsInitialValueNested(null);
    }

    public A withNewNotEqualsInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new NotEquals(left, right));
    }

    public NotEqualsInitialValueNested<A> withNewNotEqualsInitialValueLike(NotEquals item) {
        return new NotEqualsInitialValueNested(item);
    }

    public NotInitialValueNested<A> withNewNotInitialValue() {
        return new NotInitialValueNested(null);
    }

    public NotInitialValueNested<A> withNewNotInitialValueLike(Not item) {
        return new NotInitialValueNested(item);
    }

    public PlusInitialValueNested<A> withNewPlusInitialValue() {
        return new PlusInitialValueNested(null);
    }

    public A withNewPlusInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Plus(left, right));
    }

    public PlusInitialValueNested<A> withNewPlusInitialValueLike(Plus item) {
        return new PlusInitialValueNested(item);
    }

    public PositiveInitialValueNested<A> withNewPositiveInitialValue() {
        return new PositiveInitialValueNested(null);
    }

    public PositiveInitialValueNested<A> withNewPositiveInitialValueLike(Positive item) {
        return new PositiveInitialValueNested(item);
    }

    public PostDecrementInitialValueNested<A> withNewPostDecrementInitialValue() {
        return new PostDecrementInitialValueNested(null);
    }

    public PostDecrementInitialValueNested<A> withNewPostDecrementInitialValueLike(PostDecrement item) {
        return new PostDecrementInitialValueNested(item);
    }

    public PostIncrementInitialValueNested<A> withNewPostIncrementInitialValue() {
        return new PostIncrementInitialValueNested(null);
    }

    public PostIncrementInitialValueNested<A> withNewPostIncrementInitialValueLike(PostIncrement item) {
        return new PostIncrementInitialValueNested(item);
    }

    public PreDecrementInitialValueNested<A> withNewPreDecrementInitialValue() {
        return new PreDecrementInitialValueNested(null);
    }

    public PreDecrementInitialValueNested<A> withNewPreDecrementInitialValueLike(PreDecrement item) {
        return new PreDecrementInitialValueNested(item);
    }

    public PreIncrementInitialValueNested<A> withNewPreIncrementInitialValue() {
        return new PreIncrementInitialValueNested(null);
    }

    public PreIncrementInitialValueNested<A> withNewPreIncrementInitialValueLike(PreIncrement item) {
        return new PreIncrementInitialValueNested(item);
    }

    public PrimitiveRefTypeNested<A> withNewPrimitiveRefType() {
        return new PrimitiveRefTypeNested(null);
    }

    public PrimitiveRefTypeNested<A> withNewPrimitiveRefTypeLike(PrimitiveRef item) {
        return new PrimitiveRefTypeNested(item);
    }

    public PropertyInitialValueNested<A> withNewPropertyInitialValue() {
        return new PropertyInitialValueNested(null);
    }

    public PropertyInitialValueNested<A> withNewPropertyInitialValueLike(Property item) {
        return new PropertyInitialValueNested(item);
    }

    public PropertyRefInitialValueNested<A> withNewPropertyRefInitialValue() {
        return new PropertyRefInitialValueNested(null);
    }

    public PropertyRefInitialValueNested<A> withNewPropertyRefInitialValueLike(PropertyRef item) {
        return new PropertyRefInitialValueNested(item);
    }

    public RightShiftInitialValueNested<A> withNewRightShiftInitialValue() {
        return new RightShiftInitialValueNested(null);
    }

    public A withNewRightShiftInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new RightShift(left, right));
    }

    public RightShiftInitialValueNested<A> withNewRightShiftInitialValueLike(RightShift item) {
        return new RightShiftInitialValueNested(item);
    }

    public RightUnsignedShiftInitialValueNested<A> withNewRightUnsignedShiftInitialValue() {
        return new RightUnsignedShiftInitialValueNested(null);
    }

    public A withNewRightUnsignedShiftInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new RightUnsignedShift(left, right));
    }

    public RightUnsignedShiftInitialValueNested<A> withNewRightUnsignedShiftInitialValueLike(RightUnsignedShift item) {
        return new RightUnsignedShiftInitialValueNested(item);
    }

    public SuperInitialValueNested<A> withNewSuperInitialValue() {
        return new SuperInitialValueNested(null);
    }

    public SuperInitialValueNested<A> withNewSuperInitialValueLike(Super item) {
        return new SuperInitialValueNested(item);
    }

    public TernaryInitialValueNested<A> withNewTernaryInitialValue() {
        return new TernaryInitialValueNested(null);
    }

    public TernaryInitialValueNested<A> withNewTernaryInitialValueLike(Ternary item) {
        return new TernaryInitialValueNested(item);
    }

    public ThisInitialValueNested<A> withNewThisInitialValue() {
        return new ThisInitialValueNested(null);
    }

    public ThisInitialValueNested<A> withNewThisInitialValueLike(This item) {
        return new ThisInitialValueNested(item);
    }

    public TypeParamRefTypeNested<A> withNewTypeParamRefType() {
        return new TypeParamRefTypeNested(null);
    }

    public TypeParamRefTypeNested<A> withNewTypeParamRefTypeLike(TypeParamRef item) {
        return new TypeParamRefTypeNested(item);
    }

    public ValueRefInitialValueNested<A> withNewValueRefInitialValue() {
        return new ValueRefInitialValueNested(null);
    }

    public A withNewValueRefInitialValue(Object value) {
        return this.withInitialValue((Expression)new ValueRef(value));
    }

    public ValueRefInitialValueNested<A> withNewValueRefInitialValueLike(ValueRef item) {
        return new ValueRefInitialValueNested(item);
    }

    public VoidRefTypeNested<A> withNewVoidRefType() {
        return new VoidRefTypeNested(null);
    }

    public VoidRefTypeNested<A> withNewVoidRefTypeLike(VoidRef item) {
        return new VoidRefTypeNested(item);
    }

    public WildcardRefTypeNested<A> withNewWildcardRefType() {
        return new WildcardRefTypeNested(null);
    }

    public WildcardRefTypeNested<A> withNewWildcardRefTypeLike(WildcardRef item) {
        return new WildcardRefTypeNested(item);
    }

    public XorInitialValueNested<A> withNewXorInitialValue() {
        return new XorInitialValueNested(null);
    }

    public A withNewXorInitialValue(Object left, Object right) {
        return this.withInitialValue((Expression)new Xor(left, right));
    }

    public XorInitialValueNested<A> withNewXorInitialValueLike(Xor item) {
        return new XorInitialValueNested(item);
    }

    public A withSynthetic() {
        return this.withSynthetic(true);
    }

    public A withSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
        return (A)((Object)this);
    }

    public A withTypeRef(TypeRef typeRef) {
        if (typeRef == null) {
            this.typeRef = null;
            this._visitables.remove((Object)"typeRef");
            return (A)((Object)this);
        }
        VisitableBuilder builder = PropertyFluent.builder(typeRef);
        this._visitables.get((Object)"typeRef").clear();
        this._visitables.get((Object)"typeRef").add(builder);
        this.typeRef = builder;
        return (A)((Object)this);
    }

    public class AnnotationsNested<N>
    extends AnnotationRefFluent<AnnotationsNested<N>>
    implements Nested<N> {
        AnnotationRefBuilder builder;
        int index;

        AnnotationsNested(int index, AnnotationRef item) {
            this.index = index;
            this.builder = new AnnotationRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.setToAnnotations(this.index, this.builder.build());
        }

        public N endAnnotation() {
            return this.and();
        }
    }

    public class AssignInitialValueNested<N>
    extends AssignFluent<AssignInitialValueNested<N>>
    implements Nested<N> {
        AssignBuilder builder;

        AssignInitialValueNested(Assign item) {
            this.builder = new AssignBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endAssignInitialValue() {
            return this.and();
        }
    }

    public class BinaryExpressionInitialValueNested<N>
    extends BinaryExpressionFluent<BinaryExpressionInitialValueNested<N>>
    implements Nested<N> {
        BinaryExpressionBuilder builder;

        BinaryExpressionInitialValueNested(BinaryExpression item) {
            this.builder = new BinaryExpressionBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endBinaryExpressionInitialValue() {
            return this.and();
        }
    }

    public class BitwiseAndInitialValueNested<N>
    extends BitwiseAndFluent<BitwiseAndInitialValueNested<N>>
    implements Nested<N> {
        BitwiseAndBuilder builder;

        BitwiseAndInitialValueNested(BitwiseAnd item) {
            this.builder = new BitwiseAndBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endBitwiseAndInitialValue() {
            return this.and();
        }
    }

    public class BitwiseOrInitialValueNested<N>
    extends BitwiseOrFluent<BitwiseOrInitialValueNested<N>>
    implements Nested<N> {
        BitwiseOrBuilder builder;

        BitwiseOrInitialValueNested(BitwiseOr item) {
            this.builder = new BitwiseOrBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endBitwiseOrInitialValue() {
            return this.and();
        }
    }

    public class CastInitialValueNested<N>
    extends CastFluent<CastInitialValueNested<N>>
    implements Nested<N> {
        CastBuilder builder;

        CastInitialValueNested(Cast item) {
            this.builder = new CastBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endCastInitialValue() {
            return this.and();
        }
    }

    public class ClassRefInitialValueNested<N>
    extends ClassRefFluent<ClassRefInitialValueNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;

        ClassRefInitialValueNested(ClassRef item) {
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endClassRefInitialValue() {
            return this.and();
        }
    }

    public class ClassRefTypeNested<N>
    extends ClassRefFluent<ClassRefTypeNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;

        ClassRefTypeNested(ClassRef item) {
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endClassRefType() {
            return this.and();
        }
    }

    public class ConstructInitialValueNested<N>
    extends ConstructFluent<ConstructInitialValueNested<N>>
    implements Nested<N> {
        ConstructBuilder builder;

        ConstructInitialValueNested(Construct item) {
            this.builder = new ConstructBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endConstructInitialValue() {
            return this.and();
        }
    }

    public class ContextRefInitialValueNested<N>
    extends ContextRefFluent<ContextRefInitialValueNested<N>>
    implements Nested<N> {
        ContextRefBuilder builder;

        ContextRefInitialValueNested(ContextRef item) {
            this.builder = new ContextRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endContextRefInitialValue() {
            return this.and();
        }
    }

    public class DeclareInitialValueNested<N>
    extends DeclareFluent<DeclareInitialValueNested<N>>
    implements Nested<N> {
        DeclareBuilder builder;

        DeclareInitialValueNested(Declare item) {
            this.builder = new DeclareBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endDeclareInitialValue() {
            return this.and();
        }
    }

    public class DivideInitialValueNested<N>
    extends DivideFluent<DivideInitialValueNested<N>>
    implements Nested<N> {
        DivideBuilder builder;

        DivideInitialValueNested(Divide item) {
            this.builder = new DivideBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endDivideInitialValue() {
            return this.and();
        }
    }

    public class DotClassInitialValueNested<N>
    extends DotClassFluent<DotClassInitialValueNested<N>>
    implements Nested<N> {
        DotClassBuilder builder;

        DotClassInitialValueNested(DotClass item) {
            this.builder = new DotClassBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endDotClassInitialValue() {
            return this.and();
        }
    }

    public class EmptyInitialValueNested<N>
    extends EmptyFluent<EmptyInitialValueNested<N>>
    implements Nested<N> {
        EmptyBuilder builder;

        EmptyInitialValueNested(Empty item) {
            this.builder = new EmptyBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endEmptyInitialValue() {
            return this.and();
        }
    }

    public class EnclosedInitialValueNested<N>
    extends EnclosedFluent<EnclosedInitialValueNested<N>>
    implements Nested<N> {
        EnclosedBuilder builder;

        EnclosedInitialValueNested(Enclosed item) {
            this.builder = new EnclosedBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endEnclosedInitialValue() {
            return this.and();
        }
    }

    public class EqualsInitialValueNested<N>
    extends EqualsFluent<EqualsInitialValueNested<N>>
    implements Nested<N> {
        EqualsBuilder builder;

        EqualsInitialValueNested(Equals item) {
            this.builder = new EqualsBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endEqualsInitialValue() {
            return this.and();
        }
    }

    public class GreaterThanInitialValueNested<N>
    extends GreaterThanFluent<GreaterThanInitialValueNested<N>>
    implements Nested<N> {
        GreaterThanBuilder builder;

        GreaterThanInitialValueNested(GreaterThan item) {
            this.builder = new GreaterThanBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endGreaterThanInitialValue() {
            return this.and();
        }
    }

    public class GreaterThanOrEqualInitialValueNested<N>
    extends GreaterThanOrEqualFluent<GreaterThanOrEqualInitialValueNested<N>>
    implements Nested<N> {
        GreaterThanOrEqualBuilder builder;

        GreaterThanOrEqualInitialValueNested(GreaterThanOrEqual item) {
            this.builder = new GreaterThanOrEqualBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endGreaterThanOrEqualInitialValue() {
            return this.and();
        }
    }

    public class IndexInitialValueNested<N>
    extends IndexFluent<IndexInitialValueNested<N>>
    implements Nested<N> {
        IndexBuilder builder;

        IndexInitialValueNested(Index item) {
            this.builder = new IndexBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endIndexInitialValue() {
            return this.and();
        }
    }

    public class InstanceOfInitialValueNested<N>
    extends InstanceOfFluent<InstanceOfInitialValueNested<N>>
    implements Nested<N> {
        InstanceOfBuilder builder;

        InstanceOfInitialValueNested(InstanceOf item) {
            this.builder = new InstanceOfBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endInstanceOfInitialValue() {
            return this.and();
        }
    }

    public class InverseInitialValueNested<N>
    extends InverseFluent<InverseInitialValueNested<N>>
    implements Nested<N> {
        InverseBuilder builder;

        InverseInitialValueNested(Inverse item) {
            this.builder = new InverseBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endInverseInitialValue() {
            return this.and();
        }
    }

    public class LambdaInitialValueNested<N>
    extends LambdaFluent<LambdaInitialValueNested<N>>
    implements Nested<N> {
        LambdaBuilder builder;

        LambdaInitialValueNested(Lambda item) {
            this.builder = new LambdaBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endLambdaInitialValue() {
            return this.and();
        }
    }

    public class LeftShiftInitialValueNested<N>
    extends LeftShiftFluent<LeftShiftInitialValueNested<N>>
    implements Nested<N> {
        LeftShiftBuilder builder;

        LeftShiftInitialValueNested(LeftShift item) {
            this.builder = new LeftShiftBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endLeftShiftInitialValue() {
            return this.and();
        }
    }

    public class LessThanInitialValueNested<N>
    extends LessThanFluent<LessThanInitialValueNested<N>>
    implements Nested<N> {
        LessThanBuilder builder;

        LessThanInitialValueNested(LessThan item) {
            this.builder = new LessThanBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endLessThanInitialValue() {
            return this.and();
        }
    }

    public class LessThanOrEqualInitialValueNested<N>
    extends LessThanOrEqualFluent<LessThanOrEqualInitialValueNested<N>>
    implements Nested<N> {
        LessThanOrEqualBuilder builder;

        LessThanOrEqualInitialValueNested(LessThanOrEqual item) {
            this.builder = new LessThanOrEqualBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endLessThanOrEqualInitialValue() {
            return this.and();
        }
    }

    public class LogicalAndInitialValueNested<N>
    extends LogicalAndFluent<LogicalAndInitialValueNested<N>>
    implements Nested<N> {
        LogicalAndBuilder builder;

        LogicalAndInitialValueNested(LogicalAnd item) {
            this.builder = new LogicalAndBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endLogicalAndInitialValue() {
            return this.and();
        }
    }

    public class LogicalOrInitialValueNested<N>
    extends LogicalOrFluent<LogicalOrInitialValueNested<N>>
    implements Nested<N> {
        LogicalOrBuilder builder;

        LogicalOrInitialValueNested(LogicalOr item) {
            this.builder = new LogicalOrBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endLogicalOrInitialValue() {
            return this.and();
        }
    }

    public class MethodCallInitialValueNested<N>
    extends MethodCallFluent<MethodCallInitialValueNested<N>>
    implements Nested<N> {
        MethodCallBuilder builder;

        MethodCallInitialValueNested(MethodCall item) {
            this.builder = new MethodCallBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endMethodCallInitialValue() {
            return this.and();
        }
    }

    public class MinusInitialValueNested<N>
    extends MinusFluent<MinusInitialValueNested<N>>
    implements Nested<N> {
        MinusBuilder builder;

        MinusInitialValueNested(Minus item) {
            this.builder = new MinusBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endMinusInitialValue() {
            return this.and();
        }
    }

    public class ModuloInitialValueNested<N>
    extends ModuloFluent<ModuloInitialValueNested<N>>
    implements Nested<N> {
        ModuloBuilder builder;

        ModuloInitialValueNested(Modulo item) {
            this.builder = new ModuloBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endModuloInitialValue() {
            return this.and();
        }
    }

    public class MultiplyInitialValueNested<N>
    extends MultiplyFluent<MultiplyInitialValueNested<N>>
    implements Nested<N> {
        MultiplyBuilder builder;

        MultiplyInitialValueNested(Multiply item) {
            this.builder = new MultiplyBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endMultiplyInitialValue() {
            return this.and();
        }
    }

    public class NegativeInitialValueNested<N>
    extends NegativeFluent<NegativeInitialValueNested<N>>
    implements Nested<N> {
        NegativeBuilder builder;

        NegativeInitialValueNested(Negative item) {
            this.builder = new NegativeBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endNegativeInitialValue() {
            return this.and();
        }
    }

    public class NewArrayInitialValueNested<N>
    extends NewArrayFluent<NewArrayInitialValueNested<N>>
    implements Nested<N> {
        NewArrayBuilder builder;

        NewArrayInitialValueNested(NewArray item) {
            this.builder = new NewArrayBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endNewArrayInitialValue() {
            return this.and();
        }
    }

    public class NotEqualsInitialValueNested<N>
    extends NotEqualsFluent<NotEqualsInitialValueNested<N>>
    implements Nested<N> {
        NotEqualsBuilder builder;

        NotEqualsInitialValueNested(NotEquals item) {
            this.builder = new NotEqualsBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endNotEqualsInitialValue() {
            return this.and();
        }
    }

    public class NotInitialValueNested<N>
    extends NotFluent<NotInitialValueNested<N>>
    implements Nested<N> {
        NotBuilder builder;

        NotInitialValueNested(Not item) {
            this.builder = new NotBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endNotInitialValue() {
            return this.and();
        }
    }

    public class PlusInitialValueNested<N>
    extends PlusFluent<PlusInitialValueNested<N>>
    implements Nested<N> {
        PlusBuilder builder;

        PlusInitialValueNested(Plus item) {
            this.builder = new PlusBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPlusInitialValue() {
            return this.and();
        }
    }

    public class PositiveInitialValueNested<N>
    extends PositiveFluent<PositiveInitialValueNested<N>>
    implements Nested<N> {
        PositiveBuilder builder;

        PositiveInitialValueNested(Positive item) {
            this.builder = new PositiveBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPositiveInitialValue() {
            return this.and();
        }
    }

    public class PostDecrementInitialValueNested<N>
    extends PostDecrementFluent<PostDecrementInitialValueNested<N>>
    implements Nested<N> {
        PostDecrementBuilder builder;

        PostDecrementInitialValueNested(PostDecrement item) {
            this.builder = new PostDecrementBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPostDecrementInitialValue() {
            return this.and();
        }
    }

    public class PostIncrementInitialValueNested<N>
    extends PostIncrementFluent<PostIncrementInitialValueNested<N>>
    implements Nested<N> {
        PostIncrementBuilder builder;

        PostIncrementInitialValueNested(PostIncrement item) {
            this.builder = new PostIncrementBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPostIncrementInitialValue() {
            return this.and();
        }
    }

    public class PreDecrementInitialValueNested<N>
    extends PreDecrementFluent<PreDecrementInitialValueNested<N>>
    implements Nested<N> {
        PreDecrementBuilder builder;

        PreDecrementInitialValueNested(PreDecrement item) {
            this.builder = new PreDecrementBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPreDecrementInitialValue() {
            return this.and();
        }
    }

    public class PreIncrementInitialValueNested<N>
    extends PreIncrementFluent<PreIncrementInitialValueNested<N>>
    implements Nested<N> {
        PreIncrementBuilder builder;

        PreIncrementInitialValueNested(PreIncrement item) {
            this.builder = new PreIncrementBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPreIncrementInitialValue() {
            return this.and();
        }
    }

    public class PrimitiveRefTypeNested<N>
    extends PrimitiveRefFluent<PrimitiveRefTypeNested<N>>
    implements Nested<N> {
        PrimitiveRefBuilder builder;

        PrimitiveRefTypeNested(PrimitiveRef item) {
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endPrimitiveRefType() {
            return this.and();
        }
    }

    public class PropertyInitialValueNested<N>
    extends PropertyFluent<PropertyInitialValueNested<N>>
    implements Nested<N> {
        PropertyBuilder builder;

        PropertyInitialValueNested(Property item) {
            this.builder = new PropertyBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPropertyInitialValue() {
            return this.and();
        }
    }

    public class PropertyRefInitialValueNested<N>
    extends PropertyRefFluent<PropertyRefInitialValueNested<N>>
    implements Nested<N> {
        PropertyRefBuilder builder;

        PropertyRefInitialValueNested(PropertyRef item) {
            this.builder = new PropertyRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endPropertyRefInitialValue() {
            return this.and();
        }
    }

    public class RightShiftInitialValueNested<N>
    extends RightShiftFluent<RightShiftInitialValueNested<N>>
    implements Nested<N> {
        RightShiftBuilder builder;

        RightShiftInitialValueNested(RightShift item) {
            this.builder = new RightShiftBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endRightShiftInitialValue() {
            return this.and();
        }
    }

    public class RightUnsignedShiftInitialValueNested<N>
    extends RightUnsignedShiftFluent<RightUnsignedShiftInitialValueNested<N>>
    implements Nested<N> {
        RightUnsignedShiftBuilder builder;

        RightUnsignedShiftInitialValueNested(RightUnsignedShift item) {
            this.builder = new RightUnsignedShiftBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endRightUnsignedShiftInitialValue() {
            return this.and();
        }
    }

    public class SuperInitialValueNested<N>
    extends SuperFluent<SuperInitialValueNested<N>>
    implements Nested<N> {
        SuperBuilder builder;

        SuperInitialValueNested(Super item) {
            this.builder = new SuperBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endSuperInitialValue() {
            return this.and();
        }
    }

    public class TernaryInitialValueNested<N>
    extends TernaryFluent<TernaryInitialValueNested<N>>
    implements Nested<N> {
        TernaryBuilder builder;

        TernaryInitialValueNested(Ternary item) {
            this.builder = new TernaryBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endTernaryInitialValue() {
            return this.and();
        }
    }

    public class ThisInitialValueNested<N>
    extends ThisFluent<ThisInitialValueNested<N>>
    implements Nested<N> {
        ThisBuilder builder;

        ThisInitialValueNested(This item) {
            this.builder = new ThisBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endThisInitialValue() {
            return this.and();
        }
    }

    public class TypeParamRefTypeNested<N>
    extends TypeParamRefFluent<TypeParamRefTypeNested<N>>
    implements Nested<N> {
        TypeParamRefBuilder builder;

        TypeParamRefTypeNested(TypeParamRef item) {
            this.builder = new TypeParamRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endTypeParamRefType() {
            return this.and();
        }
    }

    public class ValueRefInitialValueNested<N>
    extends ValueRefFluent<ValueRefInitialValueNested<N>>
    implements Nested<N> {
        ValueRefBuilder builder;

        ValueRefInitialValueNested(ValueRef item) {
            this.builder = new ValueRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endValueRefInitialValue() {
            return this.and();
        }
    }

    public class VoidRefTypeNested<N>
    extends VoidRefFluent<VoidRefTypeNested<N>>
    implements Nested<N> {
        VoidRefBuilder builder;

        VoidRefTypeNested(VoidRef item) {
            this.builder = new VoidRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endVoidRefType() {
            return this.and();
        }
    }

    public class WildcardRefTypeNested<N>
    extends WildcardRefFluent<WildcardRefTypeNested<N>>
    implements Nested<N> {
        WildcardRefBuilder builder;

        WildcardRefTypeNested(WildcardRef item) {
            this.builder = new WildcardRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endWildcardRefType() {
            return this.and();
        }
    }

    public class XorInitialValueNested<N>
    extends XorFluent<XorInitialValueNested<N>>
    implements Nested<N> {
        XorBuilder builder;

        XorInitialValueNested(Xor item) {
            this.builder = new XorBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withInitialValue((Expression)this.builder.build());
        }

        public N endXorInitialValue() {
            return this.and();
        }
    }
}

