package io.sundr.model;

import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClassRefFluent<A extends io.sundr.model.ClassRefFluent<A>> extends TypeRefFluent<A> {

  private ArrayList<VisitableBuilder<? extends TypeRef, ?>> arguments = new ArrayList<VisitableBuilder<? extends TypeRef, ?>>();
  private int dimensions;
  private String fullyQualifiedName;

  public ClassRefFluent() {
  }

  public ClassRefFluent(ClassRef instance) {
    this.copyInstance(instance);
  }

  public A addAllToArguments(Collection<TypeRef> items) {
    if (this.arguments == null) {
      this.arguments = new ArrayList();
    }
    for (TypeRef item : items) {
      VisitableBuilder<? extends TypeRef, ?> builder = builder(item);
      _visitables.get("arguments").add(builder);
      this.arguments.add(builder);
    }
    return (A) this;
  }

  public ClassRefArgumentsNested<A> addNewClassRefArgument() {
    return new ClassRefArgumentsNested(-1, null);
  }

  public ClassRefArgumentsNested<A> addNewClassRefArgumentLike(ClassRef item) {
    return new ClassRefArgumentsNested(-1, item);
  }

  public PrimitiveRefArgumentsNested<A> addNewPrimitiveRefArgument() {
    return new PrimitiveRefArgumentsNested(-1, null);
  }

  public PrimitiveRefArgumentsNested<A> addNewPrimitiveRefArgumentLike(PrimitiveRef item) {
    return new PrimitiveRefArgumentsNested(-1, item);
  }

  public TypeParamRefArgumentsNested<A> addNewTypeParamRefArgument() {
    return new TypeParamRefArgumentsNested(-1, null);
  }

  public TypeParamRefArgumentsNested<A> addNewTypeParamRefArgumentLike(TypeParamRef item) {
    return new TypeParamRefArgumentsNested(-1, item);
  }

  public VoidRefArgumentsNested<A> addNewVoidRefArgument() {
    return new VoidRefArgumentsNested(-1, null);
  }

  public VoidRefArgumentsNested<A> addNewVoidRefArgumentLike(VoidRef item) {
    return new VoidRefArgumentsNested(-1, item);
  }

  public WildcardRefArgumentsNested<A> addNewWildcardRefArgument() {
    return new WildcardRefArgumentsNested(-1, null);
  }

  public WildcardRefArgumentsNested<A> addNewWildcardRefArgumentLike(WildcardRef item) {
    return new WildcardRefArgumentsNested(-1, item);
  }

  public A addToArguments(VisitableBuilder<? extends TypeRef, ?> builder) {
    if (this.arguments == null) {
      this.arguments = new ArrayList();
    }
    _visitables.get("arguments").add(builder);
    this.arguments.add(builder);
    return (A) this;
  }

  public A addToArguments(TypeRef... items) {
    if (this.arguments == null) {
      this.arguments = new ArrayList();
    }
    for (TypeRef item : items) {
      VisitableBuilder<? extends TypeRef, ?> builder = builder(item);
      _visitables.get("arguments").add(builder);
      this.arguments.add(builder);
    }
    return (A) this;
  }

  public A addToArguments(int index, VisitableBuilder<? extends TypeRef, ?> builder) {
    if (this.arguments == null) {
      this.arguments = new ArrayList();
    }
    if (index < 0 || index >= arguments.size()) {
      _visitables.get("arguments").add(builder);
      arguments.add(builder);
    } else {
      _visitables.get("arguments").add(builder);
      arguments.add(index, builder);
    }
    return (A) this;
  }

  public A addToArguments(int index, TypeRef item) {
    if (this.arguments == null) {
      this.arguments = new ArrayList();
    }
    VisitableBuilder<? extends TypeRef, ?> builder = builder(item);
    if (index < 0 || index >= arguments.size()) {
      _visitables.get("arguments").add(builder);
      arguments.add(builder);
    } else {
      _visitables.get("arguments").add(builder);
      arguments.add(index, builder);
    }
    return (A) this;
  }

  public TypeRef buildArgument(int index) {
    return this.arguments.get(index).build();
  }

  public List<TypeRef> buildArguments() {
    return build(arguments);
  }

  public TypeRef buildFirstArgument() {
    return this.arguments.get(0).build();
  }

  public TypeRef buildLastArgument() {
    return this.arguments.get(arguments.size() - 1).build();
  }

  public TypeRef buildMatchingArgument(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
    for (VisitableBuilder<? extends TypeRef, ?> item : arguments) {
      if (predicate.test(item)) {
        return item.build();
      }
    }
    return null;
  }

  protected static <T> VisitableBuilder<T, ?> builder(Object item) {
    switch (item.getClass().getName()) {
      case "ClassRef":

        return (VisitableBuilder<T, ?>) new ClassRefBuilder((ClassRef) item);

      case "PrimitiveRef":

        return (VisitableBuilder<T, ?>) new PrimitiveRefBuilder((PrimitiveRef) item);

      case "VoidRef":

        return (VisitableBuilder<T, ?>) new VoidRefBuilder((VoidRef) item);

      case "TypeParamRef":

        return (VisitableBuilder<T, ?>) new TypeParamRefBuilder((TypeParamRef) item);

      case "WildcardRef":

        return (VisitableBuilder<T, ?>) new WildcardRefBuilder((WildcardRef) item);

      default:

        return (VisitableBuilder<T, ?>) builderOf(item);

    }
  }

  protected void copyInstance(ClassRef instance) {
    if (instance != null) {
      this.withFullyQualifiedName(instance.getFullyQualifiedName());
      this.withDimensions(instance.getDimensions());
      this.withArguments(instance.getArguments());
      this.withAttributes(instance.getAttributes());
    }
  }

  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    ClassRefFluent that = (ClassRefFluent) o;
    if (!(Objects.equals(fullyQualifiedName, that.fullyQualifiedName))) {
      return false;
    }
    if (dimensions != that.dimensions) {
      return false;
    }
    if (!(Objects.equals(arguments, that.arguments))) {
      return false;
    }
    return true;
  }

  public int getDimensions() {
    return this.dimensions;
  }

  public String getFullyQualifiedName() {
    return this.fullyQualifiedName;
  }

  public boolean hasArguments() {
    return this.arguments != null && !(this.arguments.isEmpty());
  }

  public boolean hasDimensions() {
    return true;
  }

  public boolean hasFullyQualifiedName() {
    return this.fullyQualifiedName != null;
  }

  public boolean hasMatchingArgument(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
    for (VisitableBuilder<? extends TypeRef, ?> item : arguments) {
      if (predicate.test(item)) {
        return true;
      }
    }
    return false;
  }

  public int hashCode() {
    return Objects.hash(fullyQualifiedName, dimensions, arguments);
  }

  public A removeAllFromArguments(Collection<TypeRef> items) {
    if (this.arguments == null) {
      return (A) this;
    }
    for (TypeRef item : items) {
      VisitableBuilder<? extends TypeRef, ?> builder = builder(item);
      _visitables.get("arguments").remove(builder);
      this.arguments.remove(builder);
    }
    return (A) this;
  }

  public A removeFromArguments(VisitableBuilder<? extends TypeRef, ?> builder) {
    if (this.arguments == null) {
      return (A) this;
    }
    _visitables.get("arguments").remove(builder);
    this.arguments.remove(builder);
    return (A) this;
  }

  public A removeFromArguments(TypeRef... items) {
    if (this.arguments == null) {
      return (A) this;
    }
    for (TypeRef item : items) {
      VisitableBuilder<? extends TypeRef, ?> builder = builder(item);
      _visitables.get("arguments").remove(builder);
      this.arguments.remove(builder);
    }
    return (A) this;
  }

  public A removeMatchingFromArguments(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
    if (arguments == null) {
      return (A) this;
    }
    Iterator<VisitableBuilder<? extends TypeRef, ?>> each = arguments.iterator();
    List visitables = _visitables.get("arguments");
    while (each.hasNext()) {
      VisitableBuilder<? extends TypeRef, ?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A) this;
  }

  public ClassRefArgumentsNested<A> setNewClassRefArgumentLike(int index, ClassRef item) {
    return new ClassRefArgumentsNested(index, item);
  }

  public PrimitiveRefArgumentsNested<A> setNewPrimitiveRefArgumentLike(int index, PrimitiveRef item) {
    return new PrimitiveRefArgumentsNested(index, item);
  }

  public TypeParamRefArgumentsNested<A> setNewTypeParamRefArgumentLike(int index, TypeParamRef item) {
    return new TypeParamRefArgumentsNested(index, item);
  }

  public VoidRefArgumentsNested<A> setNewVoidRefArgumentLike(int index, VoidRef item) {
    return new VoidRefArgumentsNested(index, item);
  }

  public WildcardRefArgumentsNested<A> setNewWildcardRefArgumentLike(int index, WildcardRef item) {
    return new WildcardRefArgumentsNested(index, item);
  }

  public A setToArguments(int index, TypeRef item) {
    if (this.arguments == null) {
      this.arguments = new ArrayList();
    }
    VisitableBuilder<? extends TypeRef, ?> builder = builder(item);
    if (index < 0 || index >= arguments.size()) {
      _visitables.get("arguments").add(builder);
      arguments.add(builder);
    } else {
      _visitables.get("arguments").add(builder);
      arguments.set(index, builder);
    }
    return (A) this;
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(fullyQualifiedName == null)) {
      sb.append("fullyQualifiedName:");
      sb.append(fullyQualifiedName);
      sb.append(",");
    }
    sb.append("dimensions:");
    sb.append(dimensions);
    sb.append(",");
    if (!(arguments == null) && !(arguments.isEmpty())) {
      sb.append("arguments:");
      sb.append(arguments);
    }
    sb.append("}");
    return sb.toString();
  }

  public A withArguments(List<TypeRef> arguments) {
    if (arguments != null) {
      this.arguments = new ArrayList();
      for (TypeRef item : arguments) {
        this.addToArguments(item);
      }
    } else {
      this.arguments = null;
    }
    return (A) this;
  }

  public A withArguments(TypeRef... arguments) {
    if (this.arguments != null) {
      this.arguments.clear();
      _visitables.remove("arguments");
    }
    if (arguments != null) {
      for (TypeRef item : arguments) {
        this.addToArguments(item);
      }
    }
    return (A) this;
  }

  public A withDimensions(int dimensions) {
    this.dimensions = dimensions;
    return (A) this;
  }

  public A withFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return (A) this;
  }

  public class ClassRefArgumentsNested<N> extends ClassRefFluent<ClassRefArgumentsNested<N>> implements Nested<N> {

    ClassRefBuilder builder;
    int index;

    ClassRefArgumentsNested(int index, ClassRef item) {
      this.index = index;
      this.builder = new ClassRefBuilder(this, item);
    }

    public N and() {
      return (N) ClassRefFluent.this.setToArguments(index, builder.build());
    }

    public N endClassRefArgument() {
      return and();
    }

  }

  public class PrimitiveRefArgumentsNested<N> extends PrimitiveRefFluent<PrimitiveRefArgumentsNested<N>> implements Nested<N> {

    PrimitiveRefBuilder builder;
    int index;

    PrimitiveRefArgumentsNested(int index, PrimitiveRef item) {
      this.index = index;
      this.builder = new PrimitiveRefBuilder(this, item);
    }

    public N and() {
      return (N) ClassRefFluent.this.setToArguments(index, builder.build());
    }

    public N endPrimitiveRefArgument() {
      return and();
    }

  }

  public class TypeParamRefArgumentsNested<N> extends TypeParamRefFluent<TypeParamRefArgumentsNested<N>> implements Nested<N> {

    TypeParamRefBuilder builder;
    int index;

    TypeParamRefArgumentsNested(int index, TypeParamRef item) {
      this.index = index;
      this.builder = new TypeParamRefBuilder(this, item);
    }

    public N and() {
      return (N) ClassRefFluent.this.setToArguments(index, builder.build());
    }

    public N endTypeParamRefArgument() {
      return and();
    }

  }

  public class VoidRefArgumentsNested<N> extends VoidRefFluent<VoidRefArgumentsNested<N>> implements Nested<N> {

    VoidRefBuilder builder;
    int index;

    VoidRefArgumentsNested(int index, VoidRef item) {
      this.index = index;
      this.builder = new VoidRefBuilder(this, item);
    }

    public N and() {
      return (N) ClassRefFluent.this.setToArguments(index, builder.build());
    }

    public N endVoidRefArgument() {
      return and();
    }

  }

  public class WildcardRefArgumentsNested<N> extends WildcardRefFluent<WildcardRefArgumentsNested<N>> implements Nested<N> {

    WildcardRefBuilder builder;
    int index;

    WildcardRefArgumentsNested(int index, WildcardRef item) {
      this.index = index;
      this.builder = new WildcardRefBuilder(this, item);
    }

    public N and() {
      return (N) ClassRefFluent.this.setToArguments(index, builder.build());
    }

    public N endWildcardRefArgument() {
      return and();
    }

  }
}
