/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.workspace;

import io.takari.builder.internal.workspace.IncrementalFileOutputStream;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.inject.Named;

@Named
public class FilesystemWorkspace
implements Workspace {
    public Workspace.Mode getMode() {
        return Workspace.Mode.NORMAL;
    }

    public Workspace escalate() {
        return this;
    }

    public void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file " + file);
        }
    }

    public void processOutput(File outputFile) {
    }

    public OutputStream newOutputStream(File file) throws IOException {
        return new IncrementalFileOutputStream(file);
    }

    public Workspace.ResourceStatus getResourceStatus(File file, long lastModified, long length) {
        if (!this.isRegularFile(file) && !this.isDirectory(file)) {
            return Workspace.ResourceStatus.REMOVED;
        }
        if (length == file.length() && lastModified == file.lastModified()) {
            return Workspace.ResourceStatus.UNMODIFIED;
        }
        return Workspace.ResourceStatus.MODIFIED;
    }

    public boolean isPresent(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    public boolean isRegularFile(File file) {
        return Files.isRegularFile(file.toPath(), new LinkOption[0]);
    }

    public boolean isDirectory(File file) {
        return Files.isDirectory(file.toPath(), new LinkOption[0]);
    }

    public void walk(File basedir, final Workspace.FileVisitor visitor) throws IOException {
        if (!basedir.exists()) {
            return;
        }
        Path basepath = basedir.toPath();
        Files.walkFileTree(basepath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                File file = path.toFile();
                long lastModified = file.lastModified();
                long length = file.length();
                visitor.visit(file, lastModified, length, Workspace.ResourceStatus.NEW);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

